/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.hmhl.devices;

import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.channelmanager.driverspi.DeviceLocator;
import org.ogema.core.channelmanager.measurements.Value;
import org.ogema.core.model.ResourceList;
import org.ogema.core.model.simple.BooleanResource;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.resourcemanager.AccessMode;
import org.ogema.core.resourcemanager.AccessPriority;
import org.ogema.driver.hmhl.Converter;
import org.ogema.driver.hmhl.HM_hlConfig;
import org.ogema.driver.hmhl.HM_hlDevice;
import org.ogema.driver.hmhl.HM_hlDriver;
import org.ogema.driver.hmhl.models.RemoteControl;
import org.ogema.model.sensors.StateOfChargeSensor;

public class Remote
extends HM_hlDevice {
    private FloatResource batteryStatus;
    private ResourceList<BooleanResource> longPress;
    private ResourceList<BooleanResource> shortPress;
    private BooleanResource[] shorts;
    private BooleanResource[] longs;
    private boolean switchesInited;
    private int numOfSwitches;

    public Remote(HM_hlDriver driver, ApplicationManager appManager, HM_hlConfig config) {
        super(driver, appManager, config);
    }

    public Remote(HM_hlDriver driver, ApplicationManager appManager, DeviceLocator deviceLocator) {
        super(driver, appManager, deviceLocator);
        this.addMandatoryChannels();
        this.initSwitches();
    }

    @Override
    protected void parseValue(Value value, String channelAddress) {
        if (!this.switchesInited) {
            this.initSwitches();
        }
        String channelType = channelAddress.split(":")[0];
        byte[] arr = DatatypeConverter.parseHexBinary((String)channelAddress.split(":")[1]);
        if (channelType.equals("ATTRIBUTE")) {
            if (arr[0] == 0) {
                BooleanResource sw = this.shorts[arr[1] - 1];
                sw.setValue(value.getBooleanValue());
                sw.activate(true);
            } else if (arr[0] == 1) {
                BooleanResource sw = this.longs[arr[1] - 1];
                sw.setValue(value.getBooleanValue());
                sw.activate(true);
            }
        }
    }

    private void initSwitches() {
        int i = 0;
        this.shorts = new BooleanResource[this.numOfSwitches];
        this.longs = new BooleanResource[this.numOfSwitches];
        List list = this.longPress.getAllElements();
        do {
            this.longs[i] = (BooleanResource)list.get(i);
        } while (++i < this.numOfSwitches);
        i = 0;
        list = this.shortPress.getAllElements();
        do {
            this.shorts[i] = (BooleanResource)list.get(i);
        } while (++i < this.numOfSwitches);
        this.switchesInited = true;
    }

    private void addMandatoryChannels() {
        String[] channels;
        HM_hlConfig attributeConfig = new HM_hlConfig();
        attributeConfig.driverId = this.hm_hlConfig.driverId;
        attributeConfig.interfaceId = this.hm_hlConfig.interfaceId;
        attributeConfig.deviceAddress = this.hm_hlConfig.deviceAddress;
        attributeConfig.channelAddress = "ATTRIBUTE:0300";
        attributeConfig.timeout = -1L;
        attributeConfig.resourceName = this.hm_hlConfig.resourceName + "_Battery";
        attributeConfig.chLocator = this.addChannel(attributeConfig);
        RemoteControl rem = (RemoteControl)this.resourceManager.createResource(this.hm_hlConfig.resourceName, RemoteControl.class);
        StateOfChargeSensor eSens = (StateOfChargeSensor)rem.battery().chargeSensor().create();
        this.batteryStatus = (FloatResource)eSens.reading().create();
        this.batteryStatus.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
        this.batteryStatus.setValue(95.0f);
        this.longPress = (ResourceList)rem.longPress().create();
        this.shortPress = (ResourceList)rem.shortPress().create();
        rem.activate(true);
        int numOfLongElements = this.longPress.size();
        int numOfShortElements = this.shortPress.size();
        for (String channel : channels = this.deviceDescriptor.getChannels(this.type)) {
            int resourceId;
            String resName;
            int i;
            String[] splitChannel = channel.split(":");
            this.numOfSwitches = Integer.parseInt(splitChannel[2]) - Integer.parseInt(splitChannel[1]) + 1;
            if (!splitChannel[0].equals("Sw") && !splitChannel[0].equals("Btn")) continue;
            for (i = numOfLongElements; i < this.numOfSwitches; ++i) {
                if (i % 2 == 0) {
                    resName = "longPress_down_";
                    resourceId = i / 2;
                } else {
                    resName = "longPress_up_";
                    resourceId = (i - 1) / 2;
                }
                BooleanResource ll = (BooleanResource)this.longPress.addDecorator(resName + resourceId, BooleanResource.class);
                ll.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
            }
            for (i = 0; i < this.numOfSwitches; ++i) {
                attributeConfig = new HM_hlConfig();
                attributeConfig.driverId = this.hm_hlConfig.driverId;
                attributeConfig.interfaceId = this.hm_hlConfig.interfaceId;
                attributeConfig.deviceAddress = this.hm_hlConfig.deviceAddress;
                attributeConfig.channelAddress = "ATTRIBUTE:01" + Converter.toHexString((byte)(i + 1));
                attributeConfig.timeout = -1L;
                attributeConfig.resourceName = this.hm_hlConfig.resourceName + "_longPressedButton_" + i;
                attributeConfig.chLocator = this.addChannel(attributeConfig);
            }
            for (i = numOfShortElements; i < this.numOfSwitches; ++i) {
                if (i % 2 == 0) {
                    resName = "shortPress_down_";
                    resourceId = i / 2;
                } else {
                    resName = "shortPress_up_";
                    resourceId = (i - 1) / 2;
                }
                BooleanResource sh = (BooleanResource)this.shortPress.addDecorator(resName + resourceId, BooleanResource.class);
                sh.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
            }
            for (i = 0; i < this.numOfSwitches; ++i) {
                attributeConfig = new HM_hlConfig();
                attributeConfig.driverId = this.hm_hlConfig.driverId;
                attributeConfig.interfaceId = this.hm_hlConfig.interfaceId;
                attributeConfig.deviceAddress = this.hm_hlConfig.deviceAddress;
                attributeConfig.channelAddress = "ATTRIBUTE:00" + Converter.toHexString((byte)(i + 1));
                attributeConfig.timeout = -1L;
                attributeConfig.resourceName = this.hm_hlConfig.resourceName + "_shortPressedButton_" + i;
                attributeConfig.chLocator = this.addChannel(attributeConfig);
            }
        }
    }

    @Override
    protected void unifyResourceName(HM_hlConfig config) {
        config.resourceName = config.resourceName + "_Remote_" + config.deviceAddress.replace(':', '_');
    }

    @Override
    protected void terminate() {
        this.removeChannels();
    }
}

