/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.hmhl.devices;

import org.ogema.core.application.ApplicationManager;
import org.ogema.core.channelmanager.ChannelConfiguration;
import org.ogema.core.channelmanager.driverspi.DeviceLocator;
import org.ogema.core.channelmanager.measurements.BooleanValue;
import org.ogema.core.channelmanager.measurements.Value;
import org.ogema.core.model.Resource;
import org.ogema.core.model.simple.BooleanResource;
import org.ogema.core.model.units.ElectricCurrentResource;
import org.ogema.core.model.units.EnergyResource;
import org.ogema.core.model.units.FrequencyResource;
import org.ogema.core.model.units.PowerResource;
import org.ogema.core.model.units.VoltageResource;
import org.ogema.core.recordeddata.RecordedDataConfiguration;
import org.ogema.core.resourcemanager.AccessMode;
import org.ogema.core.resourcemanager.AccessPriority;
import org.ogema.core.resourcemanager.ResourceAccess;
import org.ogema.core.resourcemanager.ResourceValueListener;
import org.ogema.driver.hmhl.HM_hlConfig;
import org.ogema.driver.hmhl.HM_hlDevice;
import org.ogema.driver.hmhl.HM_hlDriver;
import org.ogema.model.connections.ElectricityConnection;
import org.ogema.model.devices.sensoractordevices.SingleSwitchBox;
import org.ogema.model.sensors.ElectricCurrentSensor;
import org.ogema.model.sensors.ElectricFrequencySensor;
import org.ogema.model.sensors.ElectricPowerSensor;
import org.ogema.model.sensors.ElectricVoltageSensor;
import org.ogema.model.sensors.EnergyAccumulatedSensor;
import org.ogema.tools.resource.util.ResourceUtils;

public class PowerMeter
extends HM_hlDevice
implements ResourceValueListener<BooleanResource> {
    private BooleanResource onOff;
    private BooleanResource isOn;
    private ElectricCurrentResource iRes;
    private VoltageResource vRes;
    private PowerResource pRes;
    private FrequencyResource fRes;
    private EnergyResource eRes;

    public PowerMeter(HM_hlDriver driver, ApplicationManager appManager, HM_hlConfig config) {
        super(driver, appManager, config);
    }

    public PowerMeter(HM_hlDriver driver, ApplicationManager appManager, DeviceLocator dl) {
        super(driver, appManager, dl);
        this.addMandatoryChannels();
    }

    @Override
    protected void parseValue(Value value, String channelAddress) {
        switch (channelAddress) {
            case "ATTRIBUTE:0001": {
                this.isOn.setValue(value.getBooleanValue());
                this.isOn.activate(true);
                break;
            }
            case "ATTRIBUTE:0002": {
                this.iRes.setValue(value.getFloatValue());
                this.iRes.activate(true);
                break;
            }
            case "ATTRIBUTE:0003": {
                this.vRes.setValue(value.getFloatValue());
                this.vRes.activate(true);
                break;
            }
            case "ATTRIBUTE:0004": {
                this.pRes.setValue(value.getFloatValue());
                this.pRes.activate(true);
                break;
            }
            case "ATTRIBUTE:0005": {
                this.fRes.setValue(value.getFloatValue());
                this.fRes.activate(true);
                break;
            }
            case "ATTRIBUTE:0006": {
                this.eRes.setValue(value.getFloatValue());
                this.eRes.activate(true);
                break;
            }
            case "COMMAND:01": {
                this.onOff.setValue(value.getBooleanValue());
            }
        }
    }

    private void addMandatoryChannels() {
        HM_hlConfig attributeConfig = new HM_hlConfig();
        attributeConfig.driverId = this.hm_hlConfig.driverId;
        attributeConfig.interfaceId = this.hm_hlConfig.interfaceId;
        attributeConfig.deviceAddress = this.hm_hlConfig.deviceAddress;
        attributeConfig.channelAddress = "ATTRIBUTE:0001";
        attributeConfig.timeout = -1L;
        attributeConfig.resourceName = this.hm_hlConfig.resourceName + "_Attribute_State";
        attributeConfig.chLocator = this.addChannel(attributeConfig);
        attributeConfig = new HM_hlConfig();
        attributeConfig.driverId = this.hm_hlConfig.driverId;
        attributeConfig.interfaceId = this.hm_hlConfig.interfaceId;
        attributeConfig.deviceAddress = this.hm_hlConfig.deviceAddress;
        attributeConfig.channelAddress = "ATTRIBUTE:0002";
        attributeConfig.timeout = -1L;
        attributeConfig.resourceName = this.hm_hlConfig.resourceName + "_Attribute_Current";
        attributeConfig.chLocator = this.addChannel(attributeConfig);
        attributeConfig = new HM_hlConfig();
        attributeConfig.driverId = this.hm_hlConfig.driverId;
        attributeConfig.interfaceId = this.hm_hlConfig.interfaceId;
        attributeConfig.deviceAddress = this.hm_hlConfig.deviceAddress;
        attributeConfig.channelAddress = "ATTRIBUTE:0003";
        attributeConfig.timeout = -1L;
        attributeConfig.resourceName = this.hm_hlConfig.resourceName + "_Attribute_Voltage";
        attributeConfig.chLocator = this.addChannel(attributeConfig);
        attributeConfig = new HM_hlConfig();
        attributeConfig.driverId = this.hm_hlConfig.driverId;
        attributeConfig.interfaceId = this.hm_hlConfig.interfaceId;
        attributeConfig.deviceAddress = this.hm_hlConfig.deviceAddress;
        attributeConfig.channelAddress = "ATTRIBUTE:0004";
        attributeConfig.timeout = -1L;
        attributeConfig.resourceName = this.hm_hlConfig.resourceName + "_Attribute_Power";
        attributeConfig.chLocator = this.addChannel(attributeConfig);
        attributeConfig = new HM_hlConfig();
        attributeConfig.driverId = this.hm_hlConfig.driverId;
        attributeConfig.interfaceId = this.hm_hlConfig.interfaceId;
        attributeConfig.deviceAddress = this.hm_hlConfig.deviceAddress;
        attributeConfig.channelAddress = "ATTRIBUTE:0005";
        attributeConfig.timeout = -1L;
        attributeConfig.resourceName = this.hm_hlConfig.resourceName + "_Attribute_Frequence";
        attributeConfig.chLocator = this.addChannel(attributeConfig);
        attributeConfig = new HM_hlConfig();
        attributeConfig.driverId = this.hm_hlConfig.driverId;
        attributeConfig.interfaceId = this.hm_hlConfig.interfaceId;
        attributeConfig.deviceAddress = this.hm_hlConfig.deviceAddress;
        attributeConfig.channelAddress = "ATTRIBUTE:0006";
        attributeConfig.timeout = -1L;
        attributeConfig.resourceName = this.hm_hlConfig.resourceName + "_Attribute_Energy";
        attributeConfig.chLocator = this.addChannel(attributeConfig);
        HM_hlConfig commandConfig = new HM_hlConfig();
        commandConfig.driverId = this.hm_hlConfig.driverId;
        commandConfig.interfaceId = this.hm_hlConfig.interfaceId;
        commandConfig.channelAddress = "COMMAND:01";
        commandConfig.resourceName = this.hm_hlConfig.resourceName + "_Command_OnOffToggle";
        commandConfig.timeout = -1L;
        commandConfig.chLocator = this.addChannel(commandConfig);
        SingleSwitchBox powerMeter = (SingleSwitchBox)this.resourceManager.createResource(this.hm_hlConfig.resourceName, SingleSwitchBox.class);
        powerMeter.onOffSwitch().create();
        this.onOff = (BooleanResource)powerMeter.onOffSwitch().stateControl().create();
        this.onOff.requestAccessMode(AccessMode.SHARED, AccessPriority.PRIO_HIGHEST);
        this.isOn = (BooleanResource)powerMeter.onOffSwitch().stateFeedback().create();
        this.isOn.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
        BooleanResource controllable = (BooleanResource)powerMeter.onOffSwitch().controllable().create();
        controllable.setValue(true);
        controllable.activate(true);
        ElectricityConnection conn = (ElectricityConnection)powerMeter.electricityConnection().create();
        ElectricCurrentSensor iSens = (ElectricCurrentSensor)conn.currentSensor().create();
        this.iRes = (ElectricCurrentResource)iSens.reading().create();
        this.iRes.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
        ElectricVoltageSensor vSens = (ElectricVoltageSensor)conn.voltageSensor().create();
        this.vRes = (VoltageResource)vSens.reading().create();
        this.vRes.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
        ElectricPowerSensor pSens = (ElectricPowerSensor)conn.powerSensor().create();
        this.pRes = (PowerResource)pSens.reading().create();
        this.pRes.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
        ElectricFrequencySensor fSens = (ElectricFrequencySensor)conn.frequencySensor().create();
        this.fRes = (FrequencyResource)fSens.reading().create();
        this.fRes.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
        EnergyAccumulatedSensor energy = (EnergyAccumulatedSensor)powerMeter.electricityConnection().energySensor().create();
        this.eRes = (EnergyResource)energy.reading().create();
        this.eRes.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
        ResourceUtils.activateComplexResources((Resource)powerMeter, (boolean)true, (ResourceAccess)this.appManager.getResourceAccess());
        this.onOff.activate(true);
        this.onOff.addValueListener((ResourceValueListener)this, true);
    }

    private void configureLogging() {
        RecordedDataConfiguration powerConf = new RecordedDataConfiguration();
        powerConf.setStorageType(RecordedDataConfiguration.StorageType.FIXED_INTERVAL);
        powerConf.setFixedInterval(60000L);
        this.pRes.getHistoricalData().setConfiguration(powerConf);
        RecordedDataConfiguration currentConfig = new RecordedDataConfiguration();
        currentConfig.setStorageType(RecordedDataConfiguration.StorageType.FIXED_INTERVAL);
        currentConfig.setFixedInterval(60000L);
        this.iRes.getHistoricalData().setConfiguration(currentConfig);
    }

    @Override
    protected void unifyResourceName(HM_hlConfig config) {
        config.resourceName = config.resourceName + "_PowerMeter_" + config.deviceAddress.replace(':', '_');
    }

    public void resourceChanged(BooleanResource resource) {
        ChannelConfiguration locator = (ChannelConfiguration)this.commandChannel.get("COMMAND:01");
        BooleanValue onOff = new BooleanValue(resource.getValue());
        if (this.isOn.getValue() != resource.getValue()) {
            this.writeToChannel(locator, (Value)onOff);
        }
    }

    @Override
    protected void terminate() {
        this.removeChannels();
    }
}

