/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.hmhl.devices;

import org.ogema.core.application.ApplicationManager;
import org.ogema.core.channelmanager.driverspi.DeviceLocator;
import org.ogema.core.channelmanager.measurements.Value;
import org.ogema.core.model.Resource;
import org.ogema.core.model.simple.BooleanResource;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.model.simple.IntegerResource;
import org.ogema.core.resourcemanager.AccessMode;
import org.ogema.core.resourcemanager.AccessPriority;
import org.ogema.core.resourcemanager.ResourceAccess;
import org.ogema.driver.hmhl.HM_hlConfig;
import org.ogema.driver.hmhl.HM_hlDevice;
import org.ogema.driver.hmhl.HM_hlDriver;
import org.ogema.model.devices.sensoractordevices.SensorDevice;
import org.ogema.model.devices.storage.ElectricityStorage;
import org.ogema.model.sensors.GenericFloatSensor;
import org.ogema.model.sensors.MotionSensor;
import org.ogema.model.sensors.StateOfChargeSensor;
import org.ogema.tools.resource.util.ResourceUtils;

public class MotionDetector
extends HM_hlDevice {
    private BooleanResource motion;
    private FloatResource brightness;
    private FloatResource batteryStatus;

    public MotionDetector(HM_hlDriver driver, ApplicationManager appManager, HM_hlConfig config) {
        super(driver, appManager, config);
    }

    public MotionDetector(HM_hlDriver driver, ApplicationManager appManager, DeviceLocator dl) {
        super(driver, appManager, dl);
        this.addMandatoryChannels();
    }

    @Override
    protected void parseValue(Value value, String channelAddress) {
        switch (channelAddress) {
            case "ATTRIBUTE:0001": {
                this.motion.setValue(value.getBooleanValue());
                this.motion.activate(true);
                break;
            }
            case "ATTRIBUTE:0002": {
                this.brightness.setValue(value.getFloatValue());
                this.brightness.activate(true);
                break;
            }
            case "ATTRIBUTE:0003": {
                this.batteryStatus.setValue(value.getFloatValue());
                this.batteryStatus.activate(true);
            }
        }
    }

    private void addMandatoryChannels() {
        HM_hlConfig attributeConfig = new HM_hlConfig();
        attributeConfig.driverId = this.hm_hlConfig.driverId;
        attributeConfig.interfaceId = this.hm_hlConfig.interfaceId;
        attributeConfig.deviceAddress = this.hm_hlConfig.deviceAddress;
        attributeConfig.channelAddress = "ATTRIBUTE:0001";
        attributeConfig.timeout = -1L;
        attributeConfig.resourceName = this.hm_hlConfig.resourceName + "_Motion";
        attributeConfig.chLocator = this.addChannel(attributeConfig);
        attributeConfig = new HM_hlConfig();
        attributeConfig.driverId = this.hm_hlConfig.driverId;
        attributeConfig.interfaceId = this.hm_hlConfig.interfaceId;
        attributeConfig.deviceAddress = this.hm_hlConfig.deviceAddress;
        attributeConfig.channelAddress = "ATTRIBUTE:0002";
        attributeConfig.timeout = -1L;
        attributeConfig.resourceName = this.hm_hlConfig.resourceName + "_Brightness";
        attributeConfig.chLocator = this.addChannel(attributeConfig);
        attributeConfig = new HM_hlConfig();
        attributeConfig.driverId = this.hm_hlConfig.driverId;
        attributeConfig.interfaceId = this.hm_hlConfig.interfaceId;
        attributeConfig.deviceAddress = this.hm_hlConfig.deviceAddress;
        attributeConfig.channelAddress = "ATTRIBUTE:0003";
        attributeConfig.timeout = -1L;
        attributeConfig.resourceName = this.hm_hlConfig.resourceName + "_BatteryStatus";
        attributeConfig.chLocator = this.addChannel(attributeConfig);
        SensorDevice motionDetector = (SensorDevice)this.resourceManager.createResource(this.hm_hlConfig.resourceName, SensorDevice.class);
        motionDetector.sensors().create();
        MotionSensor motionSensor = (MotionSensor)motionDetector.sensors().addDecorator("motion", MotionSensor.class);
        GenericFloatSensor brightnessSensor = (GenericFloatSensor)motionDetector.sensors().addDecorator("brightness", GenericFloatSensor.class);
        this.motion = (BooleanResource)motionSensor.reading().create();
        this.motion.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
        this.brightness = (FloatResource)brightnessSensor.reading().create();
        this.brightness.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
        ElectricityStorage battery = (ElectricityStorage)motionDetector.electricityStorage().create();
        ((IntegerResource)battery.type().create()).setValue(1);
        battery.type().activate(false);
        StateOfChargeSensor eSens = (StateOfChargeSensor)battery.chargeSensor().create();
        this.batteryStatus = (FloatResource)eSens.reading().create();
        this.batteryStatus.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
        ResourceUtils.activateComplexResources((Resource)motionDetector, (boolean)true, (ResourceAccess)this.appManager.getResourceAccess());
    }

    @Override
    protected void unifyResourceName(HM_hlConfig config) {
        config.resourceName = config.resourceName + "_Motion_" + config.deviceAddress.replace(':', '_');
    }

    @Override
    protected void terminate() {
        this.removeChannels();
    }
}

