/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.hmhl.devices;

import org.ogema.core.application.ApplicationManager;
import org.ogema.core.channelmanager.driverspi.DeviceLocator;
import org.ogema.core.channelmanager.measurements.Value;
import org.ogema.core.model.units.ConcentrationResource;
import org.ogema.core.resourcemanager.AccessMode;
import org.ogema.core.resourcemanager.AccessPriority;
import org.ogema.driver.hmhl.HM_hlConfig;
import org.ogema.driver.hmhl.HM_hlDevice;
import org.ogema.driver.hmhl.HM_hlDriver;
import org.ogema.model.sensors.CO2Sensor;

public class CO2Detector
extends HM_hlDevice {
    private ConcentrationResource concentration;

    public CO2Detector(HM_hlDriver driver, ApplicationManager appManager, HM_hlConfig config) {
        super(driver, appManager, config);
    }

    public CO2Detector(HM_hlDriver driver, ApplicationManager appManager, DeviceLocator dl) {
        super(driver, appManager, dl);
        this.addMandatoryChannels();
    }

    @Override
    protected void parseValue(Value value, String channelAddress) {
        switch (channelAddress) {
            case "ATTRIBUTE:0001": {
                this.concentration.setValue(value.getFloatValue());
                this.concentration.activate(true);
            }
        }
    }

    private void addMandatoryChannels() {
        HM_hlConfig attributeConfig = new HM_hlConfig();
        attributeConfig.driverId = this.hm_hlConfig.driverId;
        attributeConfig.interfaceId = this.hm_hlConfig.interfaceId;
        attributeConfig.deviceAddress = this.hm_hlConfig.deviceAddress;
        attributeConfig.channelAddress = "ATTRIBUTE:0001";
        attributeConfig.timeout = -1L;
        attributeConfig.resourceName = this.hm_hlConfig.resourceName + "_CO2Contentration";
        attributeConfig.chLocator = this.addChannel(attributeConfig);
        CO2Sensor co2 = (CO2Sensor)this.resourceManager.createResource(attributeConfig.resourceName, CO2Sensor.class);
        co2.activate(false);
        this.concentration = (ConcentrationResource)co2.reading().create();
        this.concentration.requestAccessMode(AccessMode.EXCLUSIVE, AccessPriority.PRIO_HIGHEST);
    }

    @Override
    protected void unifyResourceName(HM_hlConfig config) {
        config.resourceName = config.resourceName + "_CO2_" + config.deviceAddress.replace(':', '_');
    }

    @Override
    protected void terminate() {
        this.removeChannels();
    }
}

