/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.hmhl;

import java.util.Hashtable;
import java.util.Map;
import org.apache.felix.service.command.Descriptor;
import org.ogema.core.channelmanager.ChannelAccessException;
import org.ogema.core.channelmanager.ChannelConfiguration;
import org.ogema.core.channelmanager.driverspi.DeviceScanListener;
import org.ogema.core.channelmanager.measurements.Value;
import org.ogema.driver.hmhl.HM_hlConfig;
import org.ogema.driver.hmhl.HM_hlDevice;
import org.ogema.driver.hmhl.HM_hlDriver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ShellCommands {
    private HM_hlDriver driver = null;
    private final ServiceRegistration<ShellCommands> sr;

    public ShellCommands(HM_hlDriver driver, BundleContext context) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("osgi.command.scope", "hmhl");
        props.put("osgi.command.function", new String[]{"showCreatedChannels", "createChannel", "deleteChannel", "readChannel", "writeChannel", "deviceScan"});
        this.driver = driver;
        this.sr = context.registerService(ShellCommands.class, (Object)this, props);
    }

    void close() {
        this.sr.unregister();
    }

    @Descriptor(value="Lists the channelLocator String of all created Channels.")
    public void showCreatedChannels() {
        for (Map.Entry<String, HM_hlDevice> deviceEntry : this.driver.devices.entrySet()) {
            for (Map.Entry<String, ChannelConfiguration> attributeChannelEntry : deviceEntry.getValue().attributeChannel.entrySet()) {
                System.out.println(attributeChannelEntry.getKey());
            }
            for (Map.Entry<String, ChannelConfiguration> commandChannelEntry : deviceEntry.getValue().commandChannel.entrySet()) {
                System.out.println(commandChannelEntry.getKey());
            }
        }
    }

    @Descriptor(value="Creates a new channel.")
    public void createChannel(@Descriptor(value="The interface ID/Port name.") String interfaceId, @Descriptor(value="The device address in form of DeviceId e. g. 000000.") String deviceAddress, @Descriptor(value="The channel address in form e. g. Attribute:0000.") String channelAddress, @Descriptor(value="The period in which the ChannelManager should try to request a new value. 0 for commands.") long timeout, @Descriptor(value="A name for the resource.") String resourceName) {
        HM_hlConfig config = new HM_hlConfig();
        config.interfaceId = interfaceId;
        config.deviceAddress = deviceAddress.toUpperCase();
        config.channelAddress = channelAddress.toUpperCase();
        config.timeout = timeout;
        config.deviceId = deviceAddress;
        config.resourceName = this.driver.appManager.getResourceManagement().getUniqueResourceName(resourceName);
        config.deviceParameters = "";
        System.out.println(config.resourceName + " = " + config.interfaceId + " " + config.deviceAddress + " " + config.channelAddress);
        this.driver.resourceAvailable(config);
    }

    @Descriptor(value="Write to a channel. This can mean overwriting a Attribute or sending a Command.")
    public void writeChannel(@Descriptor(value="The interface ID/Port name.") String interfaceId, @Descriptor(value="The device address in form of DeviceId e. g. 000000.") String deviceAddress, @Descriptor(value="The channel address in form of Type:Id e. g. Type:Attribute:0000.") String channelAddress, @Descriptor(value="The value as a string with hex characters e. g. 0AFF. Byte order needs to be in Little Endian Byte order") Value writeValue) {
        HM_hlDevice device = this.driver.devices.get(interfaceId + ":" + deviceAddress.toUpperCase());
        ChannelConfiguration configuration = device.attributeChannel.get(channelAddress.toUpperCase());
        if (configuration == null) {
            configuration = device.commandChannel.get(channelAddress.toUpperCase());
        }
        device.writeToChannel(configuration, writeValue);
    }

    @Descriptor(value="Write to a channel. This can mean overwriting a Attribute or sending a Command.")
    public void writeChannel(@Descriptor(value="The resourceId.") String resourceId, @Descriptor(value="The value as a string with hex characters e. g. 0AFF. Byte order needs to be in Little Endian Byte order") Value writeValue) {
        ChannelConfiguration channelConfiguration = this.driver.channelMap.get(resourceId);
        HM_hlDevice device = this.driver.devices.get(channelConfiguration.getDeviceLocator().getInterfaceName() + ":" + channelConfiguration.getDeviceLocator().getDeviceAddress().toUpperCase());
        device.writeToChannel(channelConfiguration, writeValue);
    }

    @Descriptor(value="Read from a channel.")
    public void readChannel(@Descriptor(value="The interface ID/Port name.") String interfaceId, @Descriptor(value="The device address in form of DeviceId e. g. 000000.") String deviceAddress, @Descriptor(value="The channel address in form of Type:Id e. g. Type:Attribute:0000.") String channelAddress) {
        HM_hlDevice device = this.driver.getDevice(interfaceId + ":" + deviceAddress.toUpperCase());
        System.out.print("Channel value: ");
        device.readValue(channelAddress.toUpperCase());
        device.printValue(channelAddress.toUpperCase());
    }

    @Descriptor(value="Read from a channel.")
    public void readChannel(@Descriptor(value="The resourceId.") String resourceId) {
        ChannelConfiguration channelConfiguration = this.driver.channelMap.get(resourceId);
        HM_hlDevice device = this.driver.getDevice(channelConfiguration.getDeviceLocator().getInterfaceName() + ":" + channelConfiguration.getDeviceLocator().getDeviceAddress().toUpperCase());
        System.out.print("Channel value: ");
        device.printValue(channelConfiguration.getChannelLocator().getChannelAddress().toUpperCase());
    }

    public void deviceScan(@Descriptor(value="The interface ID/Port name (USB, /dev/ttyUSB0, etc.).") String interfaceId) {
        try {
            this.driver.appManager.getChannelAccess().discoverDevices("homematic-driver", interfaceId, null, (DeviceScanListener)this.driver);
        }
        catch (ChannelAccessException e) {
            e.printStackTrace();
        }
    }
}

