/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.hmhl;

import java.util.HashMap;
import java.util.Map;
import org.ogema.core.application.Application;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.channelmanager.ChannelAccessException;
import org.ogema.core.channelmanager.ChannelConfiguration;
import org.ogema.core.channelmanager.driverspi.DeviceLocator;
import org.ogema.core.channelmanager.driverspi.DeviceScanListener;
import org.ogema.driver.hmhl.Activator;
import org.ogema.driver.hmhl.DeviceDescriptor;
import org.ogema.driver.hmhl.HM_hlConfig;
import org.ogema.driver.hmhl.HM_hlDevice;
import org.ogema.driver.hmhl.devices.CO2Detector;
import org.ogema.driver.hmhl.devices.DoorWindowSensor;
import org.ogema.driver.hmhl.devices.MotionDetector;
import org.ogema.driver.hmhl.devices.PowerMeter;
import org.ogema.driver.hmhl.devices.Remote;
import org.ogema.driver.hmhl.devices.SmokeSensor;
import org.ogema.driver.hmhl.devices.SwitchPlug;
import org.ogema.driver.hmhl.devices.THSensor;
import org.ogema.driver.hmhl.devices.Thermostat;
import org.ogema.driver.hmhl.devices.WaterSensor;
import org.slf4j.Logger;

public class HM_hlDriver
implements Application,
DeviceScanListener,
Runnable {
    protected ApplicationManager appManager;
    protected final Map<String, HM_hlDevice> devices = new HashMap<String, HM_hlDevice>();
    protected final DeviceDescriptor deviceDesc = new DeviceDescriptor();
    public final Map<String, ChannelConfiguration> channelMap = new HashMap<String, ChannelConfiguration>();
    private volatile Thread thread;
    private Logger logger;

    public void start(ApplicationManager appManager) {
        this.logger = appManager.getLogger();
        this.appManager = appManager;
        this.thread = new Thread((Runnable)this, "homematic-hl-deviceScan");
        this.thread.start();
    }

    public void stop(Application.AppStopReason reason) {
        Activator.bundleIsRunning = false;
        for (HM_hlDevice device : this.devices.values()) {
            device.close();
        }
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.thread = null;
    }

    public void resourceAvailable(HM_hlConfig config) {
        String[] splitAddress = config.channelAddress.split(":");
        HM_hlDevice device = null;
        if (!this.devices.containsKey(config.interfaceId + ":" + config.deviceAddress)) {
            String s;
            switch (s = this.deviceDesc.getSubType(splitAddress[0])) {
                case "THSensor": {
                    device = new THSensor(this, this.appManager, config);
                    this.devices.put(config.interfaceId + ":" + config.deviceAddress, device);
                    break;
                }
                case "threeStateSensor": {
                    boolean isDoorWindowContact = config.deviceParameters.equals("00B1");
                    device = isDoorWindowContact ? new DoorWindowSensor(this, this.appManager, config) : new WaterSensor(this, this.appManager, config);
                    this.devices.put(config.interfaceId + ":" + config.deviceAddress, device);
                    break;
                }
                case "thermostat": {
                    device = new Thermostat(this, this.appManager, config);
                    this.devices.put(config.interfaceId + ":" + config.deviceAddress, device);
                    break;
                }
                case "powerMeter": {
                    device = new PowerMeter(this, this.appManager, config);
                    this.devices.put(config.interfaceId + ":" + config.deviceAddress, device);
                    break;
                }
                case "switch": {
                    device = new SwitchPlug(this, this.appManager, config);
                    this.devices.put(config.interfaceId + ":" + config.deviceAddress, device);
                    break;
                }
                case "smokeDetector": {
                    device = new SmokeSensor(this, this.appManager, config);
                    this.devices.put(config.interfaceId + ":" + config.deviceAddress, device);
                    break;
                }
                case "CO2Detector": {
                    device = new CO2Detector(this, this.appManager, config);
                    this.devices.put(config.interfaceId + ":" + config.deviceAddress, device);
                    break;
                }
                case "motionDetector": {
                    device = new MotionDetector(this, this.appManager, config);
                    this.devices.put(config.interfaceId + ":" + config.deviceAddress, device);
                    break;
                }
                case "remote": 
                case "pushbutton": 
                case "swi": {
                    device = new Remote(this, this.appManager, config);
                    this.devices.put(config.interfaceId + ":" + config.deviceAddress, device);
                    break;
                }
                default: {
                    throw new RuntimeException("Type not supported: " + s);
                }
            }
        } else {
            device = this.devices.get(config.interfaceId + ":" + config.deviceAddress);
        }
        if (device != null) {
            device.addChannel(config);
        }
    }

    public HM_hlDevice getDevice(String key) {
        return this.devices.get(key);
    }

    public DeviceDescriptor getDeviceDescriptor() {
        return this.deviceDesc;
    }

    public void deviceFound(DeviceLocator deviceLocator) {
        this.logger.debug("Device found!");
        String deviceKey = deviceLocator.getInterfaceName() + ":" + deviceLocator.getDeviceAddress();
        HM_hlDevice device = null;
        if (!this.devices.containsKey(deviceKey)) {
            String s;
            switch (s = this.deviceDesc.getSubType(deviceLocator.getParameters())) {
                case "THSensor": {
                    device = new THSensor(this, this.appManager, deviceLocator);
                    break;
                }
                case "threeStateSensor": {
                    boolean isDoorWindowContact = deviceLocator.getParameters().equals("00B1");
                    if (isDoorWindowContact) {
                        device = new DoorWindowSensor(this, this.appManager, deviceLocator);
                        break;
                    }
                    device = new WaterSensor(this, this.appManager, deviceLocator);
                    break;
                }
                case "thermostat": {
                    device = new Thermostat(this, this.appManager, deviceLocator);
                    break;
                }
                case "powerMeter": {
                    device = new PowerMeter(this, this.appManager, deviceLocator);
                    break;
                }
                case "switch": {
                    device = new SwitchPlug(this, this.appManager, deviceLocator);
                    break;
                }
                case "smokeDetector": {
                    device = new SmokeSensor(this, this.appManager, deviceLocator);
                    break;
                }
                case "CO2Detector": {
                    device = new CO2Detector(this, this.appManager, deviceLocator);
                    break;
                }
                case "motionDetector": {
                    device = new MotionDetector(this, this.appManager, deviceLocator);
                    break;
                }
                case "remote": 
                case "pushbutton": 
                case "swi": {
                    device = new Remote(this, this.appManager, deviceLocator);
                    break;
                }
                default: {
                    throw new RuntimeException("Type not supported: " + s);
                }
            }
            if (device != null) {
                System.out.println(deviceKey);
            }
            this.devices.put(deviceKey, device);
        } else {
            device = this.devices.get(deviceKey);
        }
    }

    public void finished(boolean success, Exception e) {
        this.logger.debug("DeviceScan finished!");
    }

    public void progress(float ratio) {
    }

    @Override
    public void run() {
        while (Activator.bundleIsRunning) {
            try {
                Thread.sleep(23000L);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!Activator.bundleIsRunning) {
                return;
            }
            this.logger.debug("Start device scan ...");
            try {
                this.appManager.getChannelAccess().discoverDevices("homematic-driver", "USB", null, (DeviceScanListener)this);
            }
            catch (ChannelAccessException e) {
                this.logger.warn("device scan failed", e.getCause());
                e.printStackTrace();
            }
            this.logger.debug("... device scan finished!");
        }
    }
}

