/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.hmhl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.channelmanager.ChannelAccess;
import org.ogema.core.channelmanager.ChannelAccessException;
import org.ogema.core.channelmanager.ChannelConfiguration;
import org.ogema.core.channelmanager.ChannelEventListener;
import org.ogema.core.channelmanager.EventType;
import org.ogema.core.channelmanager.driverspi.ChannelLocator;
import org.ogema.core.channelmanager.driverspi.DeviceLocator;
import org.ogema.core.channelmanager.driverspi.SampledValueContainer;
import org.ogema.core.channelmanager.measurements.BooleanValue;
import org.ogema.core.channelmanager.measurements.ByteArrayValue;
import org.ogema.core.channelmanager.measurements.DoubleValue;
import org.ogema.core.channelmanager.measurements.FloatValue;
import org.ogema.core.channelmanager.measurements.IllegalConversionException;
import org.ogema.core.channelmanager.measurements.IntegerValue;
import org.ogema.core.channelmanager.measurements.ObjectValue;
import org.ogema.core.channelmanager.measurements.SampledValue;
import org.ogema.core.channelmanager.measurements.StringValue;
import org.ogema.core.channelmanager.measurements.Value;
import org.ogema.core.logging.OgemaLogger;
import org.ogema.core.resourcemanager.ResourceAccess;
import org.ogema.core.resourcemanager.ResourceManagement;
import org.ogema.driver.hmhl.Converter;
import org.ogema.driver.hmhl.DeviceDescriptor;
import org.ogema.driver.hmhl.HM_hlConfig;
import org.ogema.driver.hmhl.HM_hlDriver;

public abstract class HM_hlDevice {
    protected final ChannelAccess channelAccess;
    protected final HM_hlConfig hm_hlConfig;
    protected final ResourceManagement resourceManager;
    protected final ResourceAccess resourceAccess;
    protected final DeviceLocator deviceLocator;
    protected final ApplicationManager appManager;
    protected final DeviceDescriptor deviceDescriptor;
    protected final String type;
    protected final Map<String, ChannelConfiguration> attributeChannel;
    protected final List<ChannelConfiguration> channelList;
    protected final Map<String, ChannelConfiguration> commandChannel;
    protected ChannelEventListener channelEventListener;
    protected long timeout;
    protected String dataResourceId;
    protected int resourceNameCounter;
    protected HM_hlDriver driver;
    protected final OgemaLogger logger;

    public HM_hlDevice(HM_hlDriver driver, ApplicationManager appManager, HM_hlConfig config) {
        this.attributeChannel = new HashMap<String, ChannelConfiguration>();
        this.channelList = new ArrayList<ChannelConfiguration>();
        this.commandChannel = new HashMap<String, ChannelConfiguration>();
        this.channelAccess = appManager.getChannelAccess();
        this.resourceManager = appManager.getResourceManagement();
        this.resourceAccess = appManager.getResourceAccess();
        this.appManager = appManager;
        this.logger = appManager.getLogger();
        this.hm_hlConfig = config;
        this.type = config.channelAddress.split(":")[0];
        this.driver = driver;
        this.deviceDescriptor = driver.getDeviceDescriptor();
        this.deviceLocator = new DeviceLocator(config.driverId, config.interfaceId, config.deviceAddress, config.deviceParameters);
        this.channelEventListener = new ChannelEventListener(){

            public void channelEvent(EventType type, List<SampledValueContainer> channels) {
                for (SampledValueContainer c : channels) {
                    try {
                        this.updateChannelValue(c.getChannelLocator().getChannelAddress(), c.getSampledValue().getValue());
                    }
                    catch (IllegalConversionException e) {
                        HM_hlDevice.this.logger.debug("Changed channel value could not be read");
                    }
                }
            }

            private void updateChannelValue(String channelAddress, Value value) {
                HM_hlDevice.this.printValue(value, channelAddress);
                HM_hlDevice.this.parseValue(value, channelAddress);
            }
        };
    }

    public HM_hlDevice(HM_hlDriver driver, ApplicationManager appManager, DeviceLocator deviceLocator) {
        this.appManager = appManager;
        this.channelAccess = appManager.getChannelAccess();
        this.attributeChannel = new HashMap<String, ChannelConfiguration>();
        this.channelList = new ArrayList<ChannelConfiguration>();
        this.commandChannel = new HashMap<String, ChannelConfiguration>();
        this.resourceManager = appManager.getResourceManagement();
        this.resourceAccess = appManager.getResourceAccess();
        this.logger = appManager.getLogger();
        this.hm_hlConfig = new HM_hlConfig();
        this.driver = driver;
        this.deviceDescriptor = driver.getDeviceDescriptor();
        this.type = deviceLocator.getParameters();
        this.hm_hlConfig.interfaceId = deviceLocator.getInterfaceName();
        this.hm_hlConfig.deviceAddress = deviceLocator.getDeviceAddress();
        this.hm_hlConfig.driverId = deviceLocator.getDriverName();
        this.hm_hlConfig.deviceParameters = deviceLocator.getParameters();
        this.hm_hlConfig.resourceName = this.deviceDescriptor.getName(this.type).replace('-', '_');
        this.deviceLocator = deviceLocator;
        this.unifyResourceName(this.hm_hlConfig);
        this.channelEventListener = new ChannelEventListener(){

            public void channelEvent(EventType type, List<SampledValueContainer> channels) {
                for (SampledValueContainer c : channels) {
                    try {
                        this.updateChannelValue(c.getChannelLocator().getChannelAddress(), c.getSampledValue().getValue());
                    }
                    catch (IllegalConversionException e) {
                        HM_hlDevice.this.logger.debug("Changed channel value could not be read");
                    }
                }
            }

            private void updateChannelValue(String channelAddress, Value value) {
                HM_hlDevice.this.printValue(value, channelAddress);
                HM_hlDevice.this.parseValue(value, channelAddress);
            }
        };
    }

    protected abstract void parseValue(Value var1, String var2);

    protected ChannelLocator createChannelLocator(String channelAddress) {
        return new ChannelLocator(channelAddress, this.deviceLocator);
    }

    public void close() {
        this.terminate();
    }

    public ChannelLocator addChannel(HM_hlConfig config) {
        String[] splitAddress = config.channelAddress.split(":");
        ChannelLocator channelLocator = this.createChannelLocator(config.channelAddress);
        switch (splitAddress[0]) {
            case "COMMAND": {
                this.timeout = -1L;
                try {
                    ChannelConfiguration channelConfig = this.channelAccess.addChannel(channelLocator, ChannelConfiguration.Direction.DIRECTION_INOUT, this.timeout);
                    this.commandChannel.put(config.channelAddress, channelConfig);
                    this.driver.channelMap.put(config.resourceName, channelConfig);
                }
                catch (ChannelAccessException e) {
                    e.printStackTrace();
                }
                break;
            }
            case "ATTRIBUTE": 
            case "MULTIPLE ATTRIBUTES": {
                this.timeout = config.timeout;
                this.dataResourceId = config.resourceName;
                this.logger.debug("channel access addchannel");
                try {
                    ChannelConfiguration channelConfig = this.channelAccess.addChannel(channelLocator, ChannelConfiguration.Direction.DIRECTION_INOUT, this.timeout);
                    this.attributeChannel.put(config.channelAddress, channelConfig);
                    this.driver.channelMap.put(config.resourceName, channelConfig);
                    this.addToUpdateListener(channelConfig);
                }
                catch (ChannelAccessException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        return channelLocator;
    }

    public void writeToChannel(ChannelConfiguration channelConfiguration, Value value) {
        try {
            this.channelAccess.setChannelValue(channelConfiguration, value);
        }
        catch (ChannelAccessException e) {
            e.printStackTrace();
        }
    }

    protected void addToUpdateListener(ChannelConfiguration channelConfiguration) {
        this.channelList.add(channelConfiguration);
        try {
            this.channelAccess.registerUpdateListener(this.channelList, this.channelEventListener);
        }
        catch (ChannelAccessException e) {
            e.printStackTrace();
        }
        this.channelList.clear();
    }

    public void printValue(Value value, String channelAddress) {
        this.logger.debug("New value: ");
        String[] splitChannelAddress = channelAddress.split(":");
        if (value instanceof StringValue) {
            this.logger.debug(value.getStringValue());
        } else if (value instanceof IntegerValue) {
            this.logger.debug(Integer.toString(value.getIntegerValue()));
        } else if (value instanceof FloatValue) {
            this.logger.debug(Float.toString(value.getFloatValue()));
        } else if (value instanceof DoubleValue) {
            this.logger.debug(Double.toString(value.getDoubleValue()));
        } else if (value instanceof ByteArrayValue) {
            this.logger.debug(Converter.toHexString(value.getByteArrayValue()));
        } else if (value instanceof BooleanValue) {
            this.logger.debug(Boolean.toString(value.getBooleanValue()));
        } else if (value instanceof ObjectValue) {
            Object objectValue = value.getObjectValue();
            if (splitChannelAddress[1].equals("MULTIPLE ATTRIBUTES") && objectValue instanceof Map) {
                HashMap sampledValueMap = (HashMap)objectValue;
                for (Map.Entry mapEntry : sampledValueMap.entrySet()) {
                    this.printValue(((SampledValue)mapEntry.getValue()).getValue(), channelAddress);
                }
            }
        }
    }

    public void printValue(String channel) {
        SampledValue sampledValue = null;
        try {
            sampledValue = this.channelAccess.getChannelValue(this.attributeChannel.get(channel));
        }
        catch (ChannelAccessException e) {
            e.printStackTrace();
        }
        Value value = sampledValue.getValue();
        this.printValue(value, channel);
    }

    public void readValue(String channelAddress) {
    }

    public int getResourceNameCounter() {
        return this.resourceNameCounter++;
    }

    protected void removeChannels() {
        Set<Map.Entry<String, ChannelConfiguration>> set = this.attributeChannel.entrySet();
        for (Map.Entry<String, ChannelConfiguration> e : set) {
            this.channelAccess.deleteChannel(e.getValue());
        }
        set = this.commandChannel.entrySet();
        for (Map.Entry<String, ChannelConfiguration> e : set) {
            this.channelAccess.deleteChannel(e.getValue());
        }
    }

    protected abstract void unifyResourceName(HM_hlConfig var1);

    protected abstract void terminate();
}

