/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.hmhl;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceDescriptor {
    private JSONObject jdata;
    private String json;
    private Iterator<String> Itr;
    private Map<String, JSONObject> types = new HashMap<String, JSONObject>();
    private final Logger logger = LoggerFactory.getLogger((String)"hm_hl");

    public DeviceDescriptor() {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("deviceTypes.json");
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "iso-8859-1"), 8);
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
            is.close();
            this.json = sb.toString();
        }
        catch (Exception reader) {
            // empty catch block
        }
        try {
            Iterator keys;
            this.jdata = new JSONObject(this.json);
            this.Itr = keys = this.jdata.keys();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        while (this.Itr.hasNext()) {
            String s = this.Itr.next();
            try {
                this.types.put(s, this.jdata.getJSONObject(s));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public String getName(String type) {
        String name = null;
        try {
            name = this.types.get(type).getString("name");
        }
        catch (JSONException e) {
            this.logger.error("Homematic device Type " + type + " unknown");
        }
        return name;
    }

    public String getSubType(String type) {
        String classType = null;
        try {
            classType = this.types.get(type).getString("st");
        }
        catch (JSONException e) {
            this.logger.error("Homematic device Type " + type + " unknown");
        }
        return classType;
    }

    public String[] getChannels(String type) {
        String chnstr = null;
        String[] channels = null;
        try {
            chnstr = this.types.get(type).getString("chn");
            channels = chnstr.split(",");
        }
        catch (JSONException e) {
            this.logger.error("Homematic device Type " + type + " unknown");
        }
        return channels;
    }

    public String[] getLists(String type) {
        String lststr = null;
        String[] lists = null;
        try {
            lststr = this.types.get(type).getString("lst");
            lists = lststr.split(",");
        }
        catch (JSONException e) {
            this.logger.error("Homematic device Type " + type + " unknown");
        }
        return lists;
    }
}

