/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.driver.hmhl;

public class Converter {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String dumpHexString(byte[] array) {
        return Converter.dumpHexString(array, 0, array.length);
    }

    public static String dumpHexString(byte[] array, int offset, int length) {
        StringBuilder result = new StringBuilder();
        byte[] line = new byte[16];
        int lineIndex = 0;
        result.append("\n0x");
        result.append(Converter.toHexString(offset));
        for (int i = offset; i < offset + length; ++i) {
            if (lineIndex == 16) {
                result.append(" ");
                for (int j = 0; j < 16; ++j) {
                    if (line[j] > 32 && line[j] < 126) {
                        result.append(new String(line, j, 1));
                        continue;
                    }
                    result.append(".");
                }
                result.append("\n0x");
                result.append(Converter.toHexString(i));
                lineIndex = 0;
            }
            byte b = array[i];
            result.append(" ");
            result.append(HEX_DIGITS[b >>> 4 & 0xF]);
            result.append(HEX_DIGITS[b & 0xF]);
            line[lineIndex++] = b;
        }
        if (lineIndex != 16) {
            int i;
            int count = (16 - lineIndex) * 3;
            ++count;
            for (i = 0; i < count; ++i) {
                result.append(" ");
            }
            for (i = 0; i < lineIndex; ++i) {
                if (line[i] > 32 && line[i] < 126) {
                    result.append(new String(line, i, 1));
                    continue;
                }
                result.append(".");
            }
        }
        return result.toString();
    }

    public static String toHexString(byte b) {
        return Converter.toHexString(Converter.toByteArray(b));
    }

    public static String toHexString(byte[] array) {
        return Converter.toHexString(array, 0, array.length);
    }

    public static String toHexString(byte[] array, int offset, int length) {
        char[] buf = new char[length * 2];
        int bufIndex = 0;
        for (int i = offset; i < offset + length; ++i) {
            byte b = array[i];
            buf[bufIndex++] = HEX_DIGITS[b >>> 4 & 0xF];
            buf[bufIndex++] = HEX_DIGITS[b & 0xF];
        }
        return new String(buf);
    }

    public static String toHexString(int i) {
        return Converter.toHexString(Converter.toByteArray(i));
    }

    public static byte[] toByteArray(byte b) {
        byte[] array = new byte[]{b};
        return array;
    }

    public static byte[] toByteArray(int i) {
        byte[] array = new byte[4];
        array[3] = (byte)(i & 0xFF);
        array[2] = (byte)(i >> 8 & 0xFF);
        array[1] = (byte)(i >> 16 & 0xFF);
        array[0] = (byte)(i >> 24 & 0xFF);
        return array;
    }

    public static int toByte(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new RuntimeException("Invalid hex char '" + c + "'");
    }

    public static byte[] hexStringToByteArray(String hexString) {
        int length = hexString.length();
        byte[] buffer = new byte[length / 2];
        for (int i = 0; i < length; i += 2) {
            buffer[i / 2] = (byte)(Converter.toByte(hexString.charAt(i)) << 4 | Converter.toByte(hexString.charAt(i + 1)));
        }
        return buffer;
    }

    public static long toLong(byte by) {
        return Converter.toLong(Converter.toByteArray(by), 0, 1);
    }

    public static long toLong(byte[] byteArray, int offset, int len) {
        long val = 0L;
        len = Math.min(len, 8);
        for (int i = 0; i <= len - 1; ++i) {
            val |= ((long)byteArray[offset + len - 1 - i] & 0xFFL) << 8 * i;
        }
        return val;
    }

    public static long toLong(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    public static int toInt(long value) {
        return (int)(value & 0xFFFFFFFFL);
    }
}

