/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.logdatavisualisation;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.model.Resource;
import org.ogema.core.model.schedule.Schedule;
import org.ogema.core.model.simple.BooleanResource;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.model.simple.IntegerResource;
import org.ogema.core.resourcemanager.ResourceAccess;
import org.ogema.logdatavisualisation.DataGen;

public class LogDataVisualizationServlet
extends HttpServlet {
    private static final long serialVersionUID = 550753654103033620L;
    private ResourceAccess resourceAccess = null;

    public LogDataVisualizationServlet(ApplicationManager applicationManager) {
        this.resourceAccess = applicationManager.getResourceAccess();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String requestedDataType = req.getParameter("dataType");
        String result = "no data";
        if (requestedDataType.equals("resourceData")) {
            result = this.generateFlottChartResourceData().generateJSON();
        }
        if (requestedDataType.equals("scheduleData")) {
            result = this.generateFlottChartScheduleData().generateJSON();
        }
        resp.getWriter().write(result);
        resp.setStatus(200);
    }

    private DataGen generateFlottChartResourceData() {
        DataGen flottChartData = new DataGen();
        for (FloatResource resource : this.resourceAccess.getResources(FloatResource.class)) {
            flottChartData.addRecordedDataForResource(resource.getHistoricalData(), (Resource)resource);
        }
        for (FloatResource resource : this.resourceAccess.getResources(IntegerResource.class)) {
            flottChartData.addRecordedDataForResource(resource.getHistoricalData(), (Resource)resource);
        }
        for (FloatResource resource : this.resourceAccess.getResources(BooleanResource.class)) {
            flottChartData.addRecordedDataForResource(resource.getHistoricalData(), (Resource)resource);
        }
        return flottChartData;
    }

    private DataGen generateFlottChartScheduleData() {
        DataGen flottChartData = new DataGen();
        for (Schedule schedule : this.resourceAccess.getResources(Schedule.class)) {
            flottChartData.addSchedule(schedule);
        }
        return flottChartData;
    }
}

