/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.logdatavisualisation;

import javax.servlet.Servlet;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.ogema.core.application.Application;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.logging.OgemaLogger;
import org.ogema.core.resourcemanager.ResourceAccess;
import org.ogema.core.resourcemanager.ResourceManagement;
import org.ogema.logdatavisualisation.LogDataVisualizationServlet;

@Component(specVersion="1.1", immediate=true)
@Service(value={Application.class})
public class LogDataVisualization
implements Application {
    protected OgemaLogger logger;
    protected ApplicationManager appMan;
    protected ResourceManagement resMan;
    protected ResourceAccess resAcc;
    private String webResourceBrowserPath;
    private String servletPath;

    public void start(ApplicationManager appManager) {
        this.appMan = appManager;
        this.logger = appManager.getLogger();
        this.resMan = appManager.getResourceManagement();
        this.resAcc = appManager.getResourceAccess();
        this.logger.debug("{} started", (Object)this.getClass().getName());
        String webResourcePackage = "org.ogema.logdatavisualisation";
        webResourcePackage = webResourcePackage.replace(".", "/");
        String appNameLowerCase = "LogDataVisualization";
        appNameLowerCase = appNameLowerCase.toLowerCase();
        this.webResourceBrowserPath = "/ogema/" + appNameLowerCase;
        String webResourcePackagePath = webResourcePackage + "/gui";
        this.servletPath = "/apps/ogema/" + appNameLowerCase;
        appManager.getWebAccessManager().registerWebResource(this.webResourceBrowserPath, webResourcePackagePath);
        appManager.getWebAccessManager().registerWebResource(this.servletPath, (Servlet)new LogDataVisualizationServlet(appManager));
    }

    public void stop(Application.AppStopReason reason) {
        this.appMan.getWebAccessManager().unregisterWebResource(this.webResourceBrowserPath);
        this.appMan.getWebAccessManager().unregisterWebResource(this.servletPath);
    }
}

