/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.logdatavisualisation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.ogema.core.channelmanager.measurements.SampledValue;
import org.ogema.core.model.Resource;
import org.ogema.core.model.schedule.Schedule;
import org.ogema.core.recordeddata.RecordedData;
import org.ogema.core.recordeddata.RecordedDataConfiguration;
import org.ogema.core.timeseries.InterpolationMode;

public class DataGen {
    private final Map<String, Object> dataSets = new HashMap<String, Object>();
    private String currentGraphType;

    public void addRecordedDataForResource(RecordedData recordedData, Resource resource) {
        if (recordedData == null || resource == null || recordedData.getConfiguration() == null) {
            return;
        }
        try {
            InterpolationMode mode = recordedData.getInterpolationMode();
            this.addDataSetSingle(resource.getLocation(), mode, resource.getName());
        }
        catch (UnsupportedOperationException e) {
            RecordedDataConfiguration.StorageType type = recordedData.getConfiguration().getStorageType();
            if (type == RecordedDataConfiguration.StorageType.ON_VALUE_CHANGED || type == RecordedDataConfiguration.StorageType.ON_VALUE_UPDATE) {
                this.addDataSetSingle(resource.getLocation(), InterpolationMode.STEPS, resource.getName());
            }
            this.addDataSetSingle(resource.getLocation(), InterpolationMode.NONE, resource.getName());
        }
        this.addDataFor(resource.getLocation(), recordedData.getValues(0L, Long.MAX_VALUE));
    }

    public void addSchedule(Schedule schedule) {
        if (schedule == null) {
            return;
        }
        try {
            InterpolationMode mode = schedule.getInterpolationMode();
            this.addDataSetSingle(schedule.getLocation(), mode, schedule.getName());
        }
        catch (UnsupportedOperationException e) {
            this.addDataSetSingle(schedule.getLocation(), InterpolationMode.NONE, schedule.getName());
        }
        this.addDataFor(schedule.getLocation(), schedule.getValues(0L, Long.MAX_VALUE));
    }

    private void addDataFor(String uniqueName, List<SampledValue> values) {
        ArrayList<Object> flottChartData = this.getDataArray(uniqueName);
        for (SampledValue value : values) {
            ArrayList<Comparable<Date>> xyPoint = new ArrayList<Comparable<Date>>();
            xyPoint.add(new Date(value.getTimestamp()));
            xyPoint.add(Double.valueOf(value.getValue().getDoubleValue()));
            flottChartData.add(xyPoint);
        }
    }

    public void addDataSetSingle(String uniqueName, InterpolationMode mode, String label) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        HashMap<String, Boolean> type = new HashMap<String, Boolean>();
        ArrayList array = new ArrayList();
        this.currentGraphType = "points";
        if (InterpolationMode.LINEAR == mode) {
            this.currentGraphType = "lines";
            type.put("steps", false);
        }
        if (InterpolationMode.STEPS == mode) {
            this.currentGraphType = "lines";
            type.put("steps", true);
        }
        type.put("show", true);
        type.put("fill", false);
        data.put("label", label);
        data.put("data", array);
        data.put(this.currentGraphType, type);
        this.dataSets.put(uniqueName, data);
    }

    public void changeType(String uniqueName, String key, boolean value) {
        Map map = (Map)this.dataSets.get(uniqueName);
        Map typeMap = (Map)map.get(this.currentGraphType);
        typeMap.put(key, value);
    }

    public ArrayList<Object> getDataArray(String uniqueName) {
        Map map = (Map)this.dataSets.get(uniqueName);
        return (ArrayList)map.get("data");
    }

    public Map<String, Object> getDataSetMap() {
        return this.dataSets;
    }

    public String generateJSON() throws IOException {
        return new ObjectMapper().writeValueAsString(this.dataSets);
    }
}

