/*
 * Decompiled with CFR 0.152.
 */
package org.octopusden.infrastructure.bitbucket.client;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketAuthor;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketBranch;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketCommit;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketCreateProject;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketCreatePullRequest;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketCreateRepository;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketEntityList;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketJiraCommit;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketProject;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketPullRequest;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketRepository;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketTag;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketUpdateRepository;
import org.octopusden.infrastructure.bitbucket.client.dto.DefaultReviewersQuery;
import org.octopusden.infrastructure.bitbucket.client.exception.NotFoundException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'J$\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u000bH'J\u001a\u0010\f\u001a\u00020\u00032\b\b\u0001\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\rH'J\u001c\u0010\u000e\u001a\u00020\u00032\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\tH'J8\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\t2\u0014\b\u0001\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u0013H'J&\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\t2\b\b\u0001\u0010\u0016\u001a\u00020\tH'J8\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u00102\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\t2\u0014\b\u0001\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u0013H'J.\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00102\b\b\u0001\u0010\u0019\u001a\u00020\t2\u0014\b\u0001\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u0013H'J,\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\t2\b\b\u0001\u0010\u001d\u001a\u00020\u001eH'J\u0012\u0010\u001f\u001a\u00020 2\b\b\u0001\u0010\b\u001a\u00020\tH'J$\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u00102\u0014\b\u0001\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u0013H'J.\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00102\b\b\u0001\u0010\b\u001a\u00020\t2\u0014\b\u0001\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u0013H'J$\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00102\u0014\b\u0001\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u0013H'J\u001c\u0010$\u001a\u00020#2\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\tH'J8\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00102\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\t2\u0014\b\u0001\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u0013H'J$\u0010'\u001a\u00020\u00032\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020(H'\u00a8\u0006)"}, d2={"Lorg/octopusden/infrastructure/bitbucket/client/BitbucketClient;", "", "createProject", "", "dto", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketCreateProject;", "createPullRequest", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketPullRequest;", "projectKey", "", "repository", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketCreatePullRequest;", "createRepository", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketCreateRepository;", "deleteRepository", "getBranches", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketEntityList;", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketBranch;", "requestParams", "", "getCommit", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketCommit;", "id", "getCommits", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketJiraCommit;", "issueKey", "getDefaultReviewers", "", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketAuthor;", "query", "Lorg/octopusden/infrastructure/bitbucket/client/dto/DefaultReviewersQuery;", "getProject", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketProject;", "getProjects", "getRepositories", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketRepository;", "getRepository", "getTags", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketTag;", "updateRepository", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketUpdateRepository;", "bitbucket-client"})
public interface BitbucketClient {
    @RequestLine(value="GET rest/api/1.0/projects")
    @NotNull
    public BitbucketEntityList<BitbucketProject> getProjects(@QueryMap @NotNull Map<String, ? extends Object> var1);

    @RequestLine(value="GET rest/api/1.0/repos")
    @NotNull
    public BitbucketEntityList<BitbucketRepository> getRepositories(@QueryMap @NotNull Map<String, ? extends Object> var1);

    @RequestLine(value="POST rest/api/1.0/projects")
    @Headers(value={"Content-Type: application/json"})
    public void createProject(@NotNull BitbucketCreateProject var1);

    @RequestLine(value="GET rest/api/1.0/projects/{projectKey}")
    @NotNull
    public BitbucketProject getProject(@Param(value="projectKey") @NotNull String var1) throws NotFoundException;

    @RequestLine(value="GET rest/api/1.0/projects/{projectKey}/repos")
    @NotNull
    public BitbucketEntityList<BitbucketRepository> getRepositories(@Param(value="projectKey") @NotNull String var1, @QueryMap @NotNull Map<String, ? extends Object> var2);

    @RequestLine(value="GET rest/api/1.0/projects/{projectKey}/repos/{repository}")
    @NotNull
    public BitbucketRepository getRepository(@Param(value="projectKey") @NotNull String var1, @Param(value="repository") @NotNull String var2) throws NotFoundException;

    @RequestLine(value="POST rest/api/1.0/projects/{projectKey}/repos")
    @Headers(value={"Content-Type: application/json"})
    public void createRepository(@Param(value="projectKey") @NotNull String var1, @NotNull BitbucketCreateRepository var2);

    @RequestLine(value="PUT rest/api/1.0/projects/{projectKey}/repos/{repository}")
    @Headers(value={"Content-Type: application/json"})
    public void updateRepository(@Param(value="projectKey") @NotNull String var1, @Param(value="repository") @NotNull String var2, @NotNull BitbucketUpdateRepository var3);

    @RequestLine(value="DELETE rest/api/1.0/projects/{projectKey}/repos/{repository}")
    public void deleteRepository(@Param(value="projectKey") @NotNull String var1, @Param(value="repository") @NotNull String var2);

    @RequestLine(value="GET rest/api/1.0/projects/{projectKey}/repos/{repository}/commits")
    @NotNull
    public BitbucketEntityList<BitbucketCommit> getCommits(@Param(value="projectKey") @NotNull String var1, @Param(value="repository") @NotNull String var2, @QueryMap @NotNull Map<String, ? extends Object> var3);

    @RequestLine(value="GET rest/api/1.0/projects/{projectKey}/repos/{repository}/commits/{id}")
    @NotNull
    public BitbucketCommit getCommit(@Param(value="projectKey") @NotNull String var1, @Param(value="repository") @NotNull String var2, @Param(value="id") @NotNull String var3) throws NotFoundException;

    @RequestLine(value="GET rest/jira/1.0/issues/{issueKey}/commits")
    @NotNull
    public BitbucketEntityList<BitbucketJiraCommit> getCommits(@Param(value="issueKey") @NotNull String var1, @QueryMap @NotNull Map<String, ? extends Object> var2);

    @RequestLine(value="GET rest/api/1.0/projects/{projectKey}/repos/{repository}/tags")
    @NotNull
    public BitbucketEntityList<BitbucketTag> getTags(@Param(value="projectKey") @NotNull String var1, @Param(value="repository") @NotNull String var2, @QueryMap @NotNull Map<String, ? extends Object> var3);

    @RequestLine(value="GET rest/api/1.0/projects/{projectKey}/repos/{repository}/branches")
    @NotNull
    public BitbucketEntityList<BitbucketBranch> getBranches(@Param(value="projectKey") @NotNull String var1, @Param(value="repository") @NotNull String var2, @QueryMap @NotNull Map<String, ? extends Object> var3);

    @RequestLine(value="GET rest/default-reviewers/1.0/projects/{projectKey}/repos/{repository}/reviewers")
    @NotNull
    public Set<BitbucketAuthor> getDefaultReviewers(@Param(value="projectKey") @NotNull String var1, @Param(value="repository") @NotNull String var2, @QueryMap @NotNull DefaultReviewersQuery var3);

    @RequestLine(value="POST rest/api/1.0/projects/{projectKey}/repos/{repository}/pull-requests")
    @Headers(value={"Content-Type: application/json"})
    @NotNull
    public BitbucketPullRequest createPullRequest(@Param(value="projectKey") @NotNull String var1, @Param(value="repository") @NotNull String var2, @NotNull BitbucketCreatePullRequest var3);
}

