/*
 * Decompiled with CFR 0.152.
 */
package org.octopusden.infrastructure.bitbucket.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.RequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.httpclient.ApacheHttpClient;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.slf4j.Slf4jLogger;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.octopusden.infrastructure.bitbucket.client.BitbucketClient;
import org.octopusden.infrastructure.bitbucket.client.BitbucketClientErrorDecoder;
import org.octopusden.infrastructure.bitbucket.client.BitbucketClientParametersProvider;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketAuthor;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketBranch;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketCommit;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketCreateProject;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketCreatePullRequest;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketCreateRepository;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketEntityList;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketJiraCommit;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketProject;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketPullRequest;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketRepository;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketTag;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketUpdateRepository;
import org.octopusden.infrastructure.bitbucket.client.dto.DefaultReviewersQuery;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 12\u00020\u0001:\u00011B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J2\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0010H\u0016J2\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J*\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00172\u0006\u0010!\u001a\u00020\u00102\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J&\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010)\u001a\b\u0012\u0004\u0012\u00020(0\u00172\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J*\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\"\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u00172\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\u0018\u0010,\u001a\u00020+2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J2\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J \u0010/\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u000200H\u0016R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/octopusden/infrastructure/bitbucket/client/BitbucketClassicClient;", "Lorg/octopusden/infrastructure/bitbucket/client/BitbucketClient;", "apiParametersProvider", "Lorg/octopusden/infrastructure/bitbucket/client/BitbucketClientParametersProvider;", "(Lorg/octopusden/infrastructure/bitbucket/client/BitbucketClientParametersProvider;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lorg/octopusden/infrastructure/bitbucket/client/BitbucketClientParametersProvider;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "client", "createProject", "", "dto", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketCreateProject;", "createPullRequest", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketPullRequest;", "projectKey", "", "repository", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketCreatePullRequest;", "createRepository", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketCreateRepository;", "deleteRepository", "getBranches", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketEntityList;", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketBranch;", "requestParams", "", "", "getCommit", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketCommit;", "id", "getCommits", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketJiraCommit;", "issueKey", "getDefaultReviewers", "", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketAuthor;", "query", "Lorg/octopusden/infrastructure/bitbucket/client/dto/DefaultReviewersQuery;", "getProject", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketProject;", "getProjects", "getRepositories", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketRepository;", "getRepository", "getTags", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketTag;", "updateRepository", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketUpdateRepository;", "Companion", "bitbucket-client"})
public final class BitbucketClassicClient
implements BitbucketClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BitbucketClient client;

    public BitbucketClassicClient(@NotNull BitbucketClientParametersProvider apiParametersProvider, @NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)apiParametersProvider, (String)"apiParametersProvider");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.client = BitbucketClassicClient.Companion.createClient(apiParametersProvider.getApiUrl(), apiParametersProvider.getAuth().getInterceptor(), mapper);
    }

    public BitbucketClassicClient(@NotNull BitbucketClientParametersProvider apiParametersProvider) {
        Intrinsics.checkNotNullParameter((Object)apiParametersProvider, (String)"apiParametersProvider");
        this(apiParametersProvider, BitbucketClassicClient.Companion.getMapper());
    }

    @Override
    @NotNull
    public BitbucketEntityList<BitbucketProject> getProjects(@NotNull Map<String, ? extends Object> requestParams) {
        Intrinsics.checkNotNullParameter(requestParams, (String)"requestParams");
        return this.client.getProjects(requestParams);
    }

    @Override
    @NotNull
    public BitbucketEntityList<BitbucketRepository> getRepositories(@NotNull Map<String, ? extends Object> requestParams) {
        Intrinsics.checkNotNullParameter(requestParams, (String)"requestParams");
        return this.client.getRepositories(requestParams);
    }

    @Override
    public void createProject(@NotNull BitbucketCreateProject dto) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        this.client.createProject(dto);
    }

    @Override
    @NotNull
    public BitbucketProject getProject(@NotNull String projectKey) {
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        return this.client.getProject(projectKey);
    }

    @Override
    @NotNull
    public BitbucketEntityList<BitbucketRepository> getRepositories(@NotNull String projectKey, @NotNull Map<String, ? extends Object> requestParams) {
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter(requestParams, (String)"requestParams");
        return this.client.getRepositories(projectKey, requestParams);
    }

    @Override
    @NotNull
    public BitbucketRepository getRepository(@NotNull String projectKey, @NotNull String repository) {
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        return this.client.getRepository(projectKey, repository);
    }

    @Override
    public void createRepository(@NotNull String projectKey, @NotNull BitbucketCreateRepository dto) {
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        this.client.createRepository(projectKey, dto);
    }

    @Override
    public void updateRepository(@NotNull String projectKey, @NotNull String repository, @NotNull BitbucketUpdateRepository dto) {
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        this.client.updateRepository(projectKey, repository, dto);
    }

    @Override
    public void deleteRepository(@NotNull String projectKey, @NotNull String repository) {
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.client.deleteRepository(projectKey, repository);
    }

    @Override
    @NotNull
    public BitbucketEntityList<BitbucketCommit> getCommits(@NotNull String projectKey, @NotNull String repository, @NotNull Map<String, ? extends Object> requestParams) {
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter(requestParams, (String)"requestParams");
        return this.client.getCommits(projectKey, repository, requestParams);
    }

    @Override
    @NotNull
    public BitbucketCommit getCommit(@NotNull String projectKey, @NotNull String repository, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.client.getCommit(projectKey, repository, id);
    }

    @Override
    @NotNull
    public BitbucketEntityList<BitbucketJiraCommit> getCommits(@NotNull String issueKey, @NotNull Map<String, ? extends Object> requestParams) {
        Intrinsics.checkNotNullParameter((Object)issueKey, (String)"issueKey");
        Intrinsics.checkNotNullParameter(requestParams, (String)"requestParams");
        return this.client.getCommits(issueKey, requestParams);
    }

    @Override
    @NotNull
    public BitbucketEntityList<BitbucketTag> getTags(@NotNull String projectKey, @NotNull String repository, @NotNull Map<String, ? extends Object> requestParams) {
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter(requestParams, (String)"requestParams");
        return this.client.getTags(projectKey, repository, requestParams);
    }

    @Override
    @NotNull
    public BitbucketEntityList<BitbucketBranch> getBranches(@NotNull String projectKey, @NotNull String repository, @NotNull Map<String, ? extends Object> requestParams) {
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter(requestParams, (String)"requestParams");
        return this.client.getBranches(projectKey, repository, requestParams);
    }

    @Override
    @NotNull
    public Set<BitbucketAuthor> getDefaultReviewers(@NotNull String projectKey, @NotNull String repository, @NotNull DefaultReviewersQuery query) {
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return this.client.getDefaultReviewers(projectKey, repository, query);
    }

    @Override
    @NotNull
    public BitbucketPullRequest createPullRequest(@NotNull String projectKey, @NotNull String repository, @NotNull BitbucketCreatePullRequest dto) {
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        return this.client.createPullRequest(projectKey, repository, dto);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0002\u00a8\u0006\f"}, d2={"Lorg/octopusden/infrastructure/bitbucket/client/BitbucketClassicClient$Companion;", "", "()V", "createClient", "Lorg/octopusden/infrastructure/bitbucket/client/BitbucketClient;", "apiUrl", "", "interceptor", "Lfeign/RequestInterceptor;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMapper", "bitbucket-client"})
    public static final class Companion {
        private Companion() {
        }

        private final ObjectMapper getMapper() {
            ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return objectMapper;
        }

        private final BitbucketClient createClient(String apiUrl, RequestInterceptor interceptor, ObjectMapper objectMapper) {
            Object object = Feign.builder().client((Client)new ApacheHttpClient()).encoder((Encoder)new JacksonEncoder(objectMapper)).decoder((Decoder)new JacksonDecoder(objectMapper)).errorDecoder((ErrorDecoder)new BitbucketClientErrorDecoder(objectMapper)).encoder((Encoder)new JacksonEncoder(objectMapper)).decoder((Decoder)new JacksonDecoder(objectMapper)).requestInterceptor(interceptor).logger((Logger)new Slf4jLogger(BitbucketClient.class)).logLevel(Logger.Level.FULL).target(BitbucketClient.class, apiUrl);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"builder()\n              \u2026ient::class.java, apiUrl)");
            return (BitbucketClient)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

