/*
 * Decompiled with CFR 0.152.
 */
package org.octopusden.infrastructure.bitbucket.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.octopusden.infrastructure.bitbucket.client.BitbucketClient;
import org.octopusden.infrastructure.bitbucket.client.BitbucketClientKt;
import org.octopusden.infrastructure.bitbucket.client.dto.BaseBitbucketEntity;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketAuthor;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketBranch;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketCommit;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketCreatePrRef;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketCreatePullRequest;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketCreatePullRequestReviewer;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketEntityList;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketJiraCommit;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketProject;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketPullRequest;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketRepository;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketTag;
import org.octopusden.infrastructure.bitbucket.client.dto.DefaultReviewersQuery;
import org.octopusden.infrastructure.bitbucket.client.exception.NotFoundException;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000z\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001ag\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\f\b\u0000\u0010\t*\u0006\u0012\u0002\b\u00030\n2$\u0010\u000b\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000e0\r\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\u000f0\f2#\b\u0002\u0010\u0010\u001a\u001d\u0012\u0013\u0012\u0011H\t\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\fH\u0002\u001a:\u0010\u0015\u001a\u00020\u0016*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0001\u001a \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0001\u001a\u0018\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001f*\u00020\u00172\u0006\u0010#\u001a\u00020\u0001\u001a>\u0010!\u001a\b\u0012\u0004\u0012\u00020$0\u001f*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u00012\b\u0010%\u001a\u0004\u0018\u00010\u00012\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010\u0001\u001a\u0010\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u001f*\u00020\u0017\u001a\u0010\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u001f*\u00020\u0017\u001a\u0018\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u001f*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0001\u001a \u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u001f*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"DEFAULT_REVIEWERS_PATH", "", "ENTITY_LIMIT", "", "JIRA_ISSUES_PATH", "PROJECT_PATH", "REPO_PATH", "execute", "", "T", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BaseBitbucketEntity;", "function", "Lkotlin/Function1;", "", "", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketEntityList;", "filter", "Lkotlin/ParameterName;", "name", "element", "", "createPullRequestWithDefaultReviewers", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketPullRequest;", "Lorg/octopusden/infrastructure/bitbucket/client/BitbucketClient;", "projectKey", "repository", "sourceBranch", "targetBranch", "title", "description", "getBranches", "", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketBranch;", "getCommits", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketJiraCommit;", "issueKey", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketCommit;", "since", "sinceDate", "Ljava/util/Date;", "until", "getProjects", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketProject;", "getRepositories", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketRepository;", "getTags", "Lorg/octopusden/infrastructure/bitbucket/client/dto/BitbucketTag;", "bitbucket-client"})
public final class BitbucketClientKt {
    @NotNull
    public static final String PROJECT_PATH = "rest/api/1.0/projects";
    @NotNull
    public static final String REPO_PATH = "rest/api/1.0/repos";
    @NotNull
    public static final String JIRA_ISSUES_PATH = "rest/jira/1.0/issues";
    @NotNull
    public static final String DEFAULT_REVIEWERS_PATH = "rest/default-reviewers/1.0/projects";
    public static final int ENTITY_LIMIT = 100;

    @NotNull
    public static final List<BitbucketProject> getProjects(@NotNull BitbucketClient $this$getProjects) {
        Intrinsics.checkNotNullParameter((Object)$this$getProjects, (String)"<this>");
        return BitbucketClientKt.execute$default((Function1)new Function1<Map<String, ? extends Object>, BitbucketEntityList<BitbucketProject>>($this$getProjects){
            final /* synthetic */ BitbucketClient $this_getProjects;
            {
                this.$this_getProjects = $receiver;
                super(1);
            }

            @NotNull
            public final BitbucketEntityList<BitbucketProject> invoke(@NotNull Map<String, ? extends Object> parameters) {
                Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
                return this.$this_getProjects.getProjects(parameters);
            }
        }, null, 2, null);
    }

    @NotNull
    public static final List<BitbucketRepository> getRepositories(@NotNull BitbucketClient $this$getRepositories) {
        Intrinsics.checkNotNullParameter((Object)$this$getRepositories, (String)"<this>");
        return BitbucketClientKt.execute$default((Function1)new Function1<Map<String, ? extends Object>, BitbucketEntityList<BitbucketRepository>>($this$getRepositories){
            final /* synthetic */ BitbucketClient $this_getRepositories;
            {
                this.$this_getRepositories = $receiver;
                super(1);
            }

            @NotNull
            public final BitbucketEntityList<BitbucketRepository> invoke(@NotNull Map<String, ? extends Object> parameters) {
                Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
                return this.$this_getRepositories.getRepositories(parameters);
            }
        }, null, 2, null);
    }

    @NotNull
    public static final List<BitbucketRepository> getRepositories(@NotNull BitbucketClient $this$getRepositories, @NotNull String projectKey) {
        Intrinsics.checkNotNullParameter((Object)$this$getRepositories, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        return BitbucketClientKt.execute$default((Function1)new Function1<Map<String, ? extends Object>, BitbucketEntityList<BitbucketRepository>>($this$getRepositories, projectKey){
            final /* synthetic */ BitbucketClient $this_getRepositories;
            final /* synthetic */ String $projectKey;
            {
                this.$this_getRepositories = $receiver;
                this.$projectKey = $projectKey;
                super(1);
            }

            @NotNull
            public final BitbucketEntityList<BitbucketRepository> invoke(@NotNull Map<String, ? extends Object> parameters) {
                Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
                return this.$this_getRepositories.getRepositories(this.$projectKey, parameters);
            }
        }, null, 2, null);
    }

    @NotNull
    public static final List<BitbucketCommit> getCommits(@NotNull BitbucketClient $this$getCommits, @NotNull String projectKey, @NotNull String repository, @Nullable String since, @Nullable Date sinceDate, @Nullable String until) {
        String string;
        Map limitParameters;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)$this$getCommits, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                limitParameters = new LinkedHashMap();
                String string2 = since;
                if (string2 != null) {
                    String sinceValue = string2;
                    boolean bl = false;
                    limitParameters.put("since", sinceValue);
                }
                String string3 = until;
                if (string3 != null) {
                    String untilValue = string3;
                    boolean bl = false;
                    limitParameters.put("until", untilValue);
                }
                if ((string = since) == null) break block8;
                boolean bl = false;
                Function1 function1 = getCommits.filter.1.1.INSTANCE;
                string = function1;
                if (function1 != null) break block9;
            }
            Date date = sinceDate;
            if (date != null) {
                Date fromDateValue = date;
                boolean bl = false;
                string = (Function1)new Function1<BitbucketCommit, Boolean>(fromDateValue){
                    final /* synthetic */ Date $fromDateValue;
                    {
                        this.$fromDateValue = $fromDateValue;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull BitbucketCommit c) {
                        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                        return c.getAuthorTimestamp().compareTo(this.$fromDateValue) > 0;
                    }
                };
            } else {
                string = getCommits.filter.3.INSTANCE;
            }
        }
        String filter2 = string;
        return BitbucketClientKt.execute((Function1)new Function1<Map<String, ? extends Object>, BitbucketEntityList<BitbucketCommit>>($this$getCommits, projectKey, repository, (Map<String, Object>)limitParameters){
            final /* synthetic */ BitbucketClient $this_getCommits;
            final /* synthetic */ String $projectKey;
            final /* synthetic */ String $repository;
            final /* synthetic */ Map<String, Object> $limitParameters;
            {
                this.$this_getCommits = $receiver;
                this.$projectKey = $projectKey;
                this.$repository = $repository;
                this.$limitParameters = $limitParameters;
                super(1);
            }

            @NotNull
            public final BitbucketEntityList<BitbucketCommit> invoke(@NotNull Map<String, ? extends Object> parameters) {
                Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
                return this.$this_getCommits.getCommits(this.$projectKey, this.$repository, MapsKt.plus(parameters, this.$limitParameters));
            }
        }, filter2);
    }

    @NotNull
    public static final List<BitbucketJiraCommit> getCommits(@NotNull BitbucketClient $this$getCommits, @NotNull String issueKey) {
        Intrinsics.checkNotNullParameter((Object)$this$getCommits, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)issueKey, (String)"issueKey");
        return BitbucketClientKt.execute$default((Function1)new Function1<Map<String, ? extends Object>, BitbucketEntityList<BitbucketJiraCommit>>($this$getCommits, issueKey){
            final /* synthetic */ BitbucketClient $this_getCommits;
            final /* synthetic */ String $issueKey;
            {
                this.$this_getCommits = $receiver;
                this.$issueKey = $issueKey;
                super(1);
            }

            @NotNull
            public final BitbucketEntityList<BitbucketJiraCommit> invoke(@NotNull Map<String, ? extends Object> parameters) {
                Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
                return this.$this_getCommits.getCommits(this.$issueKey, parameters);
            }
        }, null, 2, null);
    }

    @NotNull
    public static final List<BitbucketTag> getTags(@NotNull BitbucketClient $this$getTags, @NotNull String projectKey, @NotNull String repository) {
        Intrinsics.checkNotNullParameter((Object)$this$getTags, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        return BitbucketClientKt.execute$default((Function1)new Function1<Map<String, ? extends Object>, BitbucketEntityList<BitbucketTag>>($this$getTags, projectKey, repository){
            final /* synthetic */ BitbucketClient $this_getTags;
            final /* synthetic */ String $projectKey;
            final /* synthetic */ String $repository;
            {
                this.$this_getTags = $receiver;
                this.$projectKey = $projectKey;
                this.$repository = $repository;
                super(1);
            }

            @NotNull
            public final BitbucketEntityList<BitbucketTag> invoke(@NotNull Map<String, ? extends Object> parameters) {
                Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
                return this.$this_getTags.getTags(this.$projectKey, this.$repository, parameters);
            }
        }, null, 2, null);
    }

    @NotNull
    public static final List<BitbucketBranch> getBranches(@NotNull BitbucketClient $this$getBranches, @NotNull String projectKey, @NotNull String repository) {
        Intrinsics.checkNotNullParameter((Object)$this$getBranches, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        return BitbucketClientKt.execute$default((Function1)new Function1<Map<String, ? extends Object>, BitbucketEntityList<BitbucketBranch>>($this$getBranches, projectKey, repository){
            final /* synthetic */ BitbucketClient $this_getBranches;
            final /* synthetic */ String $projectKey;
            final /* synthetic */ String $repository;
            {
                this.$this_getBranches = $receiver;
                this.$projectKey = $projectKey;
                this.$repository = $repository;
                super(1);
            }

            @NotNull
            public final BitbucketEntityList<BitbucketBranch> invoke(@NotNull Map<String, ? extends Object> parameters) {
                Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
                return this.$this_getBranches.getBranches(this.$projectKey, this.$repository, parameters);
            }
        }, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final BitbucketPullRequest createPullRequestWithDefaultReviewers(@NotNull BitbucketClient $this$createPullRequestWithDefaultReviewers, @NotNull String projectKey, @NotNull String repository, @NotNull String sourceBranch, @NotNull String targetBranch, @NotNull String title, @NotNull String description) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        Iterable $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)$this$createPullRequestWithDefaultReviewers, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)sourceBranch, (String)"sourceBranch");
        Intrinsics.checkNotNullParameter((Object)targetBranch, (String)"targetBranch");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        BitbucketRepository existedRepository = $this$createPullRequestWithDefaultReviewers.getRepository(projectKey, repository);
        Iterable iterable = BitbucketClientKt.getBranches($this$createPullRequestWithDefaultReviewers, projectKey, repository);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var12_13 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo22 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void bitbucketBranch;
            BitbucketBranch bitbucketBranch2 = (BitbucketBranch)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.put(bitbucketBranch.getDisplayId(), element$iv$iv);
        }
        Map branches = destination$iv$iv;
        BitbucketCreatePrRef sourceRef = BitbucketClientKt.createPullRequestWithDefaultReviewers$getRef(branches, projectKey, repository, existedRepository, "Source", sourceBranch);
        BitbucketCreatePrRef targetRef = BitbucketClientKt.createPullRequestWithDefaultReviewers$getRef(branches, projectKey, repository, existedRepository, "Target", targetBranch);
        $this$associateByTo$iv$iv = $this$createPullRequestWithDefaultReviewers.getDefaultReviewers(projectKey, repository, new DefaultReviewersQuery(((Number)existedRepository.getId()).longValue(), sourceRef.getId(), ((Number)existedRepository.getId()).longValue(), targetRef.getId()));
        boolean $i$f$map = false;
        void $i$f$associateByTo22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BitbucketAuthor bitbucketAuthor = (BitbucketAuthor)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.add(new BitbucketCreatePullRequestReviewer((BitbucketAuthor)it));
        }
        Set defaultReviewers = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        return $this$createPullRequestWithDefaultReviewers.createPullRequest(projectKey, repository, new BitbucketCreatePullRequest(title, description, sourceRef, targetRef, defaultReviewers));
    }

    /*
     * WARNING - void declaration
     */
    private static final <T extends BaseBitbucketEntity<?>> List<T> execute(Function1<? super Map<String, ? extends Object>, BitbucketEntityList<T>> function, Function1<? super T, Boolean> filter2) {
        boolean inFilter;
        BitbucketEntityList currentPartEntities;
        int pageStart = 0;
        List entities = new ArrayList();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"limit", (Object)100)};
        Map staticParameters = MapsKt.mutableMapOf((Pair[])pairArray);
        do {
            List list;
            boolean bl;
            block7: {
                Integer n = pageStart;
                staticParameters.put("start", n);
                currentPartEntities = (BitbucketEntityList)function.invoke((Object)staticParameters);
                Iterable $this$all$iv = currentPartEntities.getValues();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        if (((Boolean)filter2.invoke(element$iv)).booleanValue()) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
            }
            boolean $this$execute_u24lambda_u2d7 = bl;
            boolean bl2 = false;
            Collection collection = entities;
            if ($this$execute_u24lambda_u2d7) {
                list = currentPartEntities.getValues();
            } else {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = currentPartEntities.getValues();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    if (!((Boolean)filter2.invoke(element$iv$iv)).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            }
            Iterable iterable = list;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
            inFilter = $this$execute_u24lambda_u2d7;
            Integer n = currentPartEntities.getNextPageStart();
            int n2 = pageStart = n != null ? n : pageStart;
        } while (!currentPartEntities.isLastPage() && inFilter);
        return entities;
    }

    static /* synthetic */ List execute$default(Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            function12 = execute.1.INSTANCE;
        }
        return BitbucketClientKt.execute(function1, function12);
    }

    private static final BitbucketCreatePrRef createPullRequestWithDefaultReviewers$getRef(Map<String, BitbucketBranch> branches, String $projectKey, String $repository, BitbucketRepository existedRepository, String type, String branchName) {
        BitbucketBranch bitbucketBranch = branches.get(branchName);
        if (bitbucketBranch == null) {
            throw new NotFoundException(type + " branch '" + branchName + "' not found in '" + $projectKey + ':' + $repository + '\'');
        }
        BitbucketBranch it = bitbucketBranch;
        boolean bl = false;
        return new BitbucketCreatePrRef((String)it.getId(), existedRepository);
    }
}

