/*
 * Decompiled with CFR 0.152.
 */
package org.octopusden.infrastructure.bitbucket.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Response;
import feign.codec.ErrorDecoder;
import java.io.Closeable;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketException;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketExceptionName;
import org.octopusden.infrastructure.bitbucket.client.dto.BitbucketExceptionsResponse;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/octopusden/infrastructure/bitbucket/client/BitbucketClientErrorDecoder;", "Lfeign/codec/ErrorDecoder;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "decode", "Ljava/lang/Exception;", "Lkotlin/Exception;", "methodKey", "", "response", "Lfeign/Response;", "bitbucket-client"})
public final class BitbucketClientErrorDecoder
implements ErrorDecoder {
    @NotNull
    private final ObjectMapper objectMapper;

    public BitbucketClientErrorDecoder(@NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.objectMapper = objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Exception decode(@Nullable String methodKey, @NotNull Response response) {
        Exception exception;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Closeable closeable = (Closeable)response;
        Throwable throwable = null;
        try {
            Exception exception2;
            Response closableResponse = (Response)closeable;
            boolean bl = false;
            Closeable closeable2 = closableResponse.body().asInputStream();
            Throwable throwable2 = null;
            try {
                Exception exception3;
                InputStream inputStream = (InputStream)closeable2;
                boolean bl2 = false;
                BitbucketExceptionsResponse en = (BitbucketExceptionsResponse)this.objectMapper.readValue(inputStream, BitbucketExceptionsResponse.class);
                BitbucketException bitbucketException = (BitbucketException)CollectionsKt.firstOrNull(en.getErrors());
                if (bitbucketException != null) {
                    Exception exception4;
                    Function1<String, Exception> function1;
                    BitbucketException bitbucketException2 = bitbucketException;
                    boolean bl3 = false;
                    String message = bitbucketException2.getMessage();
                    BitbucketExceptionName bitbucketExceptionName = bitbucketException2.getExceptionName();
                    exception3 = bitbucketExceptionName != null && (function1 = bitbucketExceptionName.getExceptionSupplier()) != null && (exception4 = (Exception)function1.invoke((Object)message)) != null ? exception4 : (Exception)new IllegalStateException(message);
                } else {
                    exception3 = new IllegalStateException();
                }
                exception2 = exception3;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            exception = exception2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return exception;
    }
}

