/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Set;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public abstract class Scheme
extends HttpCondition
implements Parameterized {
    private final ParameterizedPatternParser expression;

    private Scheme(String pattern) {
        Assert.notNull(pattern, "Scheme must not be null.");
        this.expression = new RegexParameterizedPatternParser(pattern);
    }

    public static Scheme matches(final String pattern) {
        return new Scheme(pattern){

            public String toString() {
                return "Scheme.matches(\"" + pattern + "\")";
            }
        };
    }

    @Override
    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        String scheme = null;
        if (event instanceof HttpOutboundServletRewrite) {
            scheme = event.getAddress().getScheme();
            if (scheme == null) {
                scheme = ((HttpServletRequest)event.getRequest()).getScheme();
            }
        } else {
            scheme = ((HttpServletRequest)event.getRequest()).getScheme();
        }
        return scheme != null && this.expression.parse(scheme).submit(event, context);
    }

    public ParameterizedPatternParser getExpression() {
        return this.expression;
    }

    @Override
    public Set<String> getRequiredParameterNames() {
        return this.expression.getRequiredParameterNames();
    }

    @Override
    public void setParameterStore(ParameterStore store) {
        this.expression.setParameterStore(store);
    }
}

