/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.annotation.scan;

import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.io.InputStream;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.annotation.api.ClassVisitor;
import org.ocpsoft.rewrite.annotation.scan.ByteCodeFilter;
import org.ocpsoft.rewrite.annotation.scan.PackageFilter;
import org.ocpsoft.rewrite.annotation.spi.ClassFinder;

public abstract class AbstractClassFinder
implements ClassFinder {
    protected final Logger log = Logger.getLogger(this.getClass());
    protected final ServletContext servletContext;
    protected final ClassLoader classLoader;
    protected final PackageFilter packageFilter;
    private final ByteCodeFilter byteCodeFilter;

    public AbstractClassFinder(ServletContext servletContext, ClassLoader classLoader, PackageFilter packageFilter, ByteCodeFilter byteCodeFilter) {
        this.servletContext = servletContext;
        this.classLoader = classLoader;
        this.packageFilter = packageFilter;
        this.byteCodeFilter = byteCodeFilter;
    }

    protected String stripKnownPrefix(String str, String prefix) {
        int startIndex = str.lastIndexOf(prefix);
        if (startIndex != -1) {
            return str.substring(startIndex + prefix.length());
        }
        return null;
    }

    protected static String getClassName(String filename) {
        int endIndex = filename.length() - ".class".length();
        String relativePath = filename.substring(0, endIndex);
        return relativePath.replace('/', '.');
    }

    protected boolean mustProcessClass(String className) {
        if (className.startsWith("META-INF.versions")) {
            return false;
        }
        String packageName = "";
        int packageEndIndex = className.lastIndexOf(".");
        if (packageEndIndex != -1) {
            packageName = className.substring(0, packageEndIndex);
        }
        return this.packageFilter.isAllowedPackage(packageName);
    }

    protected void processClass(String className, InputStream classFileStream, ClassVisitor visitor) {
        block9: {
            if (className.equals("module-info")) {
                return;
            }
            if (classFileStream != null) {
                try {
                    boolean shouldScanClass = this.byteCodeFilter.accept(classFileStream);
                    if (!shouldScanClass) {
                        return;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Bytecode filter recommends to scan class: " + className);
                    }
                }
                catch (IOException e) {
                    if (!this.log.isDebugEnabled()) break block9;
                    this.log.debug("Failed to parse class file: " + className, e);
                }
            }
        }
        try {
            Class<?> clazz = Class.forName(className, false, this.classLoader);
            visitor.visit(clazz);
        }
        catch (NoClassDefFoundError e) {
            this.log.debug("Could not load class '" + className + "': " + e.toString());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to load class: " + className, e);
        }
    }
}

