/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.config;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.common.util.Iterators;
import org.ocpsoft.rewrite.config.And;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.ConfigurationRuleBuilderCustom;
import org.ocpsoft.rewrite.config.ConfigurationRuleBuilderOtherwise;
import org.ocpsoft.rewrite.config.ConfigurationRuleBuilderPerform;
import org.ocpsoft.rewrite.config.ConfigurationRuleBuilderWhen;
import org.ocpsoft.rewrite.config.ConfigurationRuleBuilderWithId;
import org.ocpsoft.rewrite.config.ConfigurationRuleBuilderWithMetadata;
import org.ocpsoft.rewrite.config.ConfigurationRuleBuilderWithPriority;
import org.ocpsoft.rewrite.config.ConfigurationRuleBuilderWithPriorityAndId;
import org.ocpsoft.rewrite.config.ConfigurationRuleParameterBuilder;
import org.ocpsoft.rewrite.config.Not;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.config.Perform;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.config.RuleBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedRule;
import org.ocpsoft.rewrite.spi.ConfigurationRuleBuilderInterceptor;

public class ConfigurationRuleBuilder
extends ConfigurationBuilder
implements ParameterizedRule,
ConfigurationRuleBuilderCustom,
ConfigurationRuleBuilderWhen,
ConfigurationRuleBuilderPerform,
ConfigurationRuleBuilderOtherwise,
ConfigurationRuleBuilderWithId,
ConfigurationRuleBuilderWithPriority,
ConfigurationRuleBuilderWithPriorityAndId {
    private final ConfigurationBuilder wrapped;
    private final RuleBuilder rule;
    private final List<ConfigurationRuleBuilderInterceptor> interceptors = Iterators.asList(ServiceLoader.load(ConfigurationRuleBuilderInterceptor.class));

    ConfigurationRuleBuilder(ConfigurationBuilder config, RuleBuilder rule) {
        this.wrapped = config;
        this.rule = rule;
    }

    @Override
    public ConfigurationRuleBuilder addRule(Rule rule) {
        return this.wrapped.addRule(rule);
    }

    @Override
    public ConfigurationRuleBuilderCustom addRule() {
        return this.wrapped.addRule();
    }

    @Override
    public ConfigurationRuleParameterBuilder where(String name) {
        return new ConfigurationRuleParameterBuilder(this, this.rule.where(name));
    }

    @Override
    public ConfigurationRuleBuilder when(Condition condition) {
        for (ConfigurationRuleBuilderInterceptor interceptor : this.interceptors) {
            condition = interceptor.when(condition);
        }
        this.rule.when(condition);
        return this;
    }

    @Override
    public ConfigurationRuleBuilderWhen when(Condition condition, Condition ... conditions) {
        List<Condition> list = new LinkedList<Condition>();
        list.add(condition);
        list.addAll(Arrays.asList(conditions));
        for (ConfigurationRuleBuilderInterceptor interceptor : this.interceptors) {
            list = interceptor.when(list);
        }
        this.rule.when(And.all(list.toArray(new Condition[list.size()])));
        return this;
    }

    @Override
    public ConfigurationRuleBuilder perform(Operation operation) {
        for (ConfigurationRuleBuilderInterceptor interceptor : this.interceptors) {
            operation = interceptor.perform(operation);
        }
        this.rule.perform(operation);
        return this;
    }

    @Override
    public ConfigurationRuleBuilderPerform perform(Operation operation, Operation ... operations) {
        List<Operation> list = new LinkedList<Operation>();
        list.add(operation);
        list.addAll(Arrays.asList(operations));
        for (ConfigurationRuleBuilderInterceptor interceptor : this.interceptors) {
            list = interceptor.perform(list);
        }
        this.rule.perform(Perform.all(list.toArray(new Operation[list.size()])));
        return this;
    }

    @Override
    public ConfigurationRuleBuilder otherwise(Operation operation) {
        for (ConfigurationRuleBuilderInterceptor interceptor : this.interceptors) {
            operation = interceptor.otherwise(operation);
        }
        this.wrapped.addOtherwiseRule(this.rule).when(Not.any(this.rule)).perform(operation);
        return this;
    }

    @Override
    public ConfigurationRuleBuilderOtherwise otherwise(Operation operation, Operation ... operations) {
        List<Operation> list = new LinkedList<Operation>();
        list.add(operation);
        list.addAll(Arrays.asList(operations));
        for (ConfigurationRuleBuilderInterceptor interceptor : this.interceptors) {
            list = interceptor.otherwise(list);
        }
        this.wrapped.addOtherwiseRule(this.rule).when(Not.any(this.rule)).perform(Perform.all(list.toArray(new Operation[list.size()])));
        return this;
    }

    @Override
    public ConfigurationRuleBuilder withPriority(int priority) {
        for (ConfigurationRuleBuilderInterceptor interceptor : this.interceptors) {
            priority = interceptor.withPriority(priority);
        }
        this.rule.withPriority(priority);
        return this;
    }

    @Override
    public ConfigurationRuleBuilder withId(String id) {
        for (ConfigurationRuleBuilderInterceptor interceptor : this.interceptors) {
            id = interceptor.withId(id);
        }
        this.rule.withId(id);
        return this;
    }

    public RuleBuilder getRuleBuilder() {
        return this.rule;
    }

    @Override
    public List<Rule> getRules() {
        return this.wrapped.getRules();
    }

    @Override
    public List<RuleBuilder> getRuleBuilders() {
        return this.wrapped.getRuleBuilders();
    }

    @Override
    public ParameterStore getParameterStore() {
        return this.rule.getParameterStore();
    }

    @Override
    public String getId() {
        return this.rule.getId();
    }

    @Override
    public boolean evaluate(Rewrite event, EvaluationContext context) {
        return this.rule.evaluate(event, context);
    }

    @Override
    public void perform(Rewrite event, EvaluationContext context) {
        this.rule.perform(event, context);
    }

    @Override
    public Set<String> getRequiredParameterNames() {
        HashSet<String> result = new HashSet<String>();
        if (this.rule instanceof Parameterized) {
            result.addAll(this.rule.getRequiredParameterNames());
        }
        return result;
    }

    @Override
    public void setParameterStore(ParameterStore store) {
        if (this.rule instanceof Parameterized) {
            this.rule.setParameterStore(store);
        }
    }

    @Override
    public ConfigurationRuleBuilderWithMetadata withMetadata(Object key, Object value) {
        this.rule.put(key, value);
        return this;
    }
}

