/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Arrays;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.common.util.Strings;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public abstract class ServerPort
extends HttpCondition {
    private final int[] ports;

    private ServerPort(int ... ports) {
        Assert.notNull(ports, "Must specify at least one valid port.");
        for (int port : ports) {
            if (port >= 1 && port <= 65535) continue;
            throw new IllegalArgumentException("Invalid port number: " + ports + " - must be between 1 and 65535, inclusive.");
        }
        this.ports = ports;
    }

    public static ServerPort is(final int ... ports) {
        return new ServerPort(ports){

            public String toString() {
                return "ServerPort.is(" + Strings.join(Arrays.asList(new int[][]{ports}), ", ") + ")";
            }
        };
    }

    @Override
    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        int serverPort = event.getAddress().getPort();
        for (int port : this.ports) {
            if (serverPort != port) continue;
            return true;
        }
        return false;
    }
}

