/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.config;

import java.util.Arrays;
import java.util.List;
import org.ocpsoft.rewrite.config.And;
import org.ocpsoft.rewrite.config.CompositeCondition;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.config.Not;
import org.ocpsoft.rewrite.config.Or;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;

public abstract class DefaultConditionBuilder
implements ConditionBuilder {
    @Override
    public ConditionBuilder and(final Condition condition) {
        final DefaultConditionBuilder self = this;
        if (condition == null) {
            return this;
        }
        return new DefaultConditionBuilderInternal(new Condition[]{self, condition}){

            @Override
            public boolean evaluate(Rewrite event, EvaluationContext context) {
                return And.all(self, condition).evaluate(event, context);
            }

            public String toString() {
                return self + ".and(" + condition + ")";
            }
        };
    }

    @Override
    public ConditionBuilder andNot(final Condition condition) {
        final DefaultConditionBuilder self = this;
        if (condition == null) {
            return this;
        }
        return new DefaultConditionBuilderInternal(new Condition[]{self, condition}){

            @Override
            public boolean evaluate(Rewrite event, EvaluationContext context) {
                return And.all(self, Not.any(condition)).evaluate(event, context);
            }

            public String toString() {
                return self + ".andNot(" + condition + ")";
            }
        };
    }

    @Override
    public ConditionBuilder or(final Condition condition) {
        final DefaultConditionBuilder self = this;
        if (condition == null) {
            return this;
        }
        return new DefaultConditionBuilderInternal(new Condition[]{self, condition}){

            @Override
            public boolean evaluate(Rewrite event, EvaluationContext context) {
                return Or.any(self, condition).evaluate(event, context);
            }

            public String toString() {
                return self + ".or(" + condition + ")";
            }
        };
    }

    @Override
    public ConditionBuilder orNot(final Condition condition) {
        final DefaultConditionBuilder self = this;
        if (condition == null) {
            return this;
        }
        return new DefaultConditionBuilderInternal(new Condition[]{self, condition}){

            @Override
            public boolean evaluate(Rewrite event, EvaluationContext context) {
                return Or.any(self, Not.any(condition)).evaluate(event, context);
            }

            public String toString() {
                return self + ".orNot(" + condition + ")";
            }
        };
    }

    public static abstract class DefaultConditionBuilderInternal
    extends DefaultConditionBuilder
    implements CompositeCondition {
        private List<Condition> conditions;

        public DefaultConditionBuilderInternal(Condition ... conditions) {
            this.conditions = Arrays.asList(conditions);
        }

        @Override
        public List<Condition> getConditions() {
            return this.conditions;
        }
    }
}

