/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.HashSet;
import java.util.Set;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.param.ConfigurableParameter;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.RegexConstraint;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.config.bind.Request;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.util.URLBuilder;
import org.ocpsoft.urlbuilder.Address;

public class Path
extends HttpCondition
implements Parameterized {
    private final ParameterizedPatternParser expression;
    private boolean withRequestBinding = false;
    private String captureIn;

    private Path(String pattern) {
        Assert.notNull(pattern, "Path must not be null.");
        this.expression = new RegexParameterizedPatternParser("[^/]+", pattern);
    }

    public static Path matches(String pattern) {
        return new Path(pattern);
    }

    public static Path captureIn(String param) {
        Path path = new Path("{" + param + "}");
        path.captureIn = param;
        return path;
    }

    public Path withRequestBinding() {
        this.withRequestBinding = true;
        return this;
    }

    @Override
    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        String url = null;
        url = event instanceof HttpOutboundServletRewrite ? ((Address)((HttpOutboundServletRewrite)event).getOutboundAddress()).getPath() : URLBuilder.createFrom(event.getInboundAddress().getPath()).decode().toPath();
        if (url.startsWith(event.getContextPath())) {
            url = url.substring(event.getContextPath().length());
        }
        return this.expression.matches(event, context, url);
    }

    public ParameterizedPatternParser getExpression() {
        return this.expression;
    }

    public String toString() {
        return this.expression.toString();
    }

    @Override
    public Set<String> getRequiredParameterNames() {
        HashSet<String> result = new HashSet<String>();
        if (this.captureIn != null) {
            result.add(this.captureIn);
        } else {
            result.addAll(this.expression.getRequiredParameterNames());
        }
        return result;
    }

    @Override
    public void setParameterStore(ParameterStore store) {
        Parameter<?> parameter;
        if (this.captureIn != null && (parameter = store.get(this.captureIn)) instanceof ConfigurableParameter) {
            ((ConfigurableParameter)parameter).constrainedBy(new RegexConstraint(".*"));
        }
        if (this.withRequestBinding) {
            for (String param : this.getRequiredParameterNames()) {
                Parameter<?> parameter2 = store.get(param);
                if (!(parameter2 instanceof ConfigurableParameter)) continue;
                ((ConfigurableParameter)parameter2).bindsTo(Request.parameter(param));
            }
            this.withRequestBinding = true;
        }
        this.expression.setParameterStore(store);
    }
}

