/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.net.MalformedURLException;
import java.util.Set;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterizationException;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.param.Transformations;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public class Resource
extends HttpCondition
implements Parameterized {
    private static final Logger log = Logger.getLogger(Resource.class);
    private final ParameterizedPatternParser resource;

    private Resource(String resource) {
        this.resource = new RegexParameterizedPatternParser(resource);
    }

    @Override
    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        if (this.resource != null) {
            try {
                String file = this.resource.getBuilder().build(event, context, Transformations.encodePath());
                try {
                    return event.getServletContext().getResource(file) != null;
                }
                catch (MalformedURLException e) {
                    log.debug("Invalid file format [{}]", file);
                }
            }
            catch (ParameterizationException e) {
                Set paths = event.getServletContext().getResourcePaths("/");
                for (String path : paths) {
                    if (!this.resource.matches(path)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Resource exists(String resource) {
        return new Resource(resource);
    }

    public ParameterizedPatternParser getResourceExpression() {
        return this.resource;
    }

    @Override
    public Set<String> getRequiredParameterNames() {
        return this.resource.getRequiredParameterNames();
    }

    @Override
    public void setParameterStore(ParameterStore store) {
        this.resource.setParameterStore(store);
    }
}

