/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.param;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.Constraint;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterizedPatternBuilder;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.ParameterizedPatternParserParameter;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternBuilder;
import org.ocpsoft.rewrite.param.Transform;
import org.ocpsoft.rewrite.util.Maps;
import org.ocpsoft.rewrite.util.ParseTools;

public class RegexParameterizedPatternParser
implements ParameterizedPatternParser {
    private static final String DEFAULT_PARAMETER_PATTERN = ".*";
    private Pattern compiledPattern;
    private String pattern;
    private final char[] chars;
    private final List<RegexGroup> groups = new ArrayList<RegexGroup>();
    private final ParameterStore<ParameterizedPatternParserParameter> parameters = new ParameterStore();
    private RegexParameterizedPatternBuilder builder;

    RegexParameterizedPatternParser(String pattern, RegexParameterizedPatternBuilder builder) {
        this(pattern);
        this.builder = builder;
    }

    public RegexParameterizedPatternParser(String pattern) {
        this(ParseTools.CaptureType.BRACE, DEFAULT_PARAMETER_PATTERN, pattern);
    }

    public RegexParameterizedPatternParser(String parameterPattern, String pattern) {
        this(ParseTools.CaptureType.BRACE, parameterPattern, pattern);
    }

    public RegexParameterizedPatternParser(ParseTools.CaptureType type, String pattern) {
        this(type, DEFAULT_PARAMETER_PATTERN, pattern);
    }

    public RegexParameterizedPatternParser(ParseTools.CaptureType type, String parameterPattern, String pattern) {
        Assert.notNull(pattern, "Pattern must not be null");
        this.pattern = pattern;
        this.chars = pattern.toCharArray();
        if (this.chars.length > 0) {
            int parameterIndex = 0;
            block3: for (int cursor = 0; cursor < this.chars.length; ++cursor) {
                switch (this.chars[cursor]) {
                    case '{': {
                        int startPos = cursor;
                        ParseTools.CapturingGroup group = ParseTools.balancedCapture(this.chars, startPos, this.chars.length - 1, type);
                        cursor = group.getEnd();
                        this.groups.add(new RegexGroup(group, parameterIndex++));
                        String parameterName = new String(group.getCaptured());
                        this.parameters.where(parameterName, (ParameterizedPatternParserParameter)new ParameterizedPatternParserParameter(this, parameterName).matches(parameterPattern));
                        continue block3;
                    }
                }
            }
        }
    }

    @Override
    public Map<String, ParameterizedPatternParserParameter> getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public boolean matches(Rewrite event, EvaluationContext context, String value) {
        Matcher matcher = this.getMatcher(value);
        boolean result = matcher.matches();
        if (result) {
            int group = 1;
            block0: for (RegexGroup param : this.groups) {
                String matched = matcher.group(group++);
                for (Constraint c : ((ParameterizedPatternParserParameter)this.parameters.get(param.getName())).getConstraints()) {
                    if (c.isSatisfiedBy(event, context, matched)) continue;
                    result = false;
                    break block0;
                }
            }
        }
        return result;
    }

    private Matcher getMatcher(String value) {
        if (this.compiledPattern == null) {
            StringBuilder patternBuilder = new StringBuilder();
            ParseTools.CapturingGroup last = null;
            for (RegexGroup param : this.groups) {
                ParseTools.CapturingGroup capture = param.getCapture();
                if (last != null && last.getEnd() < capture.getStart() - 1) {
                    patternBuilder.append(new char[]{'\\', 'Q'});
                    patternBuilder.append(Arrays.copyOfRange(this.chars, last.getEnd() + 1, capture.getStart()));
                    patternBuilder.append(new char[]{'\\', 'E'});
                } else if (last == null && capture.getStart() > 0) {
                    patternBuilder.append(new char[]{'\\', 'Q'});
                    patternBuilder.append(Arrays.copyOfRange(this.chars, 0, capture.getStart()));
                    patternBuilder.append(new char[]{'\\', 'E'});
                }
                patternBuilder.append('(');
                patternBuilder.append(((ParameterizedPatternParserParameter)this.parameters.get(param.getName())).getPattern());
                patternBuilder.append(')');
                last = capture;
            }
            if (last != null && last.getEnd() < this.chars.length) {
                patternBuilder.append(Arrays.copyOfRange(this.chars, last.getEnd() + 1, this.chars.length));
            } else if (last == null) {
                patternBuilder.append(new char[]{'\\', 'Q'});
                patternBuilder.append(this.chars);
                patternBuilder.append(new char[]{'\\', 'E'});
            }
            this.compiledPattern = Pattern.compile(patternBuilder.toString());
        }
        Matcher matcher = this.compiledPattern.matcher(value);
        return matcher;
    }

    @Override
    public Map<ParameterizedPatternParserParameter, String[]> parse(String value) {
        LinkedHashMap<ParameterizedPatternParserParameter, String[]> values = new LinkedHashMap<ParameterizedPatternParserParameter, String[]>();
        Matcher matcher = this.getMatcher(value);
        if (matcher.matches()) {
            for (RegexGroup group : this.groups) {
                Maps.addArrayValue(values, this.parameters.get(group.getName()), matcher.group(group.getIndex() + 1));
            }
        }
        return values;
    }

    @Override
    public Map<ParameterizedPatternParserParameter, String[]> parse(Rewrite event, EvaluationContext context, String value) {
        LinkedHashMap<ParameterizedPatternParserParameter, String[]> values = new LinkedHashMap<ParameterizedPatternParserParameter, String[]>();
        Matcher matcher = this.getMatcher(value);
        if (matcher.matches()) {
            for (RegexGroup group : this.groups) {
                String capturedValue = this.applyTransforms(event, context, (ParameterizedPatternParserParameter)this.parameters.get(group.getName()), matcher.group(group.getIndex() + 1));
                Maps.addArrayValue(values, this.parameters.get(group.getName()), capturedValue);
            }
        }
        return values;
    }

    private String applyTransforms(Rewrite event, EvaluationContext context, ParameterizedPatternParserParameter param, String value) {
        String result = value;
        for (Transform t : param.getTransforms()) {
            result = t.transform(event, context, value);
        }
        return result;
    }

    @Override
    public List<String> getParameterNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (RegexGroup group : this.groups) {
            result.add(group.getName());
        }
        return result;
    }

    public String toString() {
        return new String(this.chars);
    }

    @Override
    public ParameterizedPatternParserParameter where(String param) {
        return (ParameterizedPatternParserParameter)this.parameters.get(param);
    }

    @Override
    public ParameterizedPatternParserParameter getParameter(String param) {
        return this.where(param);
    }

    @Override
    public String getPattern() {
        return this.compiledPattern.pattern();
    }

    @Override
    public ParameterizedPatternBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = new RegexParameterizedPatternBuilder(this.pattern, this);
        }
        return this.builder;
    }

    class RegexGroup {
        private final ParseTools.CapturingGroup capture;
        private final int index;

        public RegexGroup(ParseTools.CapturingGroup capture, int index) {
            this.capture = capture;
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return new String(this.capture.getCaptured());
        }

        public ParseTools.CapturingGroup getCapture() {
            return this.capture;
        }

        public String toString() {
            return "RegexParameter [name=" + this.getName() + ", capture=" + this.capture + "]";
        }
    }
}

