/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.bind;

import java.util.Arrays;
import java.util.List;
import org.ocpsoft.rewrite.bind.BindingBuilder;
import org.ocpsoft.rewrite.bind.Converter;
import org.ocpsoft.rewrite.bind.Validator;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;

public class Evaluation
extends BindingBuilder<Evaluation, Object> {
    private final CharSequence property;

    private Evaluation(CharSequence property) {
        this.property = property;
    }

    public static Evaluation property(CharSequence property) {
        return new Evaluation(property);
    }

    public static Evaluation property(CharSequence property, Class<? extends Converter<Object>> type) {
        return (Evaluation)Evaluation.property(property).convertedBy(type);
    }

    public static Evaluation property(CharSequence property, Class<Converter<Object>> converterType, Class<? extends Validator<Object>> validatorType) {
        return (Evaluation)Evaluation.property(property, converterType).validatedBy(validatorType);
    }

    @Override
    public Object submit(Rewrite event, EvaluationContext context, Object value) {
        if (!context.containsKey(this.property)) {
            if (value.getClass().isArray()) {
                this.storeValue(event, context, value);
            } else {
                this.storeValue(event, context, new Object[]{value});
            }
        } else {
            Object[] values = (Object[])context.get(this.getParameterUnconvertedName(this.property));
            List<Object> list = Arrays.asList(values);
            if (value.getClass().isArray()) {
                list.addAll(Arrays.asList((Object[])value));
            } else {
                list.add(value);
            }
            this.storeValue(event, context, list.toArray());
        }
        return null;
    }

    private void storeValue(Rewrite event, EvaluationContext context, Object value) {
        context.put(this.getParameterUnconvertedName(this.property), value);
        context.put(this.getParameterConvertedName(this.property), this.convert(event, context, value));
    }

    private String getParameterUnconvertedName(CharSequence parameter) {
        return Evaluation.class.getName() + "_" + parameter;
    }

    private String getParameterConvertedName(CharSequence parameter) {
        return this.getParameterUnconvertedName(parameter) + "_converted";
    }

    @Override
    public Object retrieve(Rewrite event, EvaluationContext context) {
        return this.retrieveFromProperty(context, this.getParameterUnconvertedName(this.property));
    }

    public Object retrieveConverted(Rewrite inbound, EvaluationContext context) {
        return this.retrieveFromProperty(context, this.getParameterConvertedName(this.property));
    }

    private Object retrieveFromProperty(EvaluationContext context, String propertyName) {
        Object[] values;
        Object object = context.get(propertyName);
        if (object == null) {
            throw new IllegalArgumentException("Attempted to access the non-existent " + this.converted(propertyName) + " EvaluationContext property \"{" + this.removePropertyNamespace(propertyName) + "}\"");
        }
        if (object.getClass().isArray() && (values = (Object[])object).length == 1) {
            return values[0];
        }
        return object;
    }

    private String converted(String propertyName) {
        return propertyName.endsWith("_converted") ? "converted" : "";
    }

    private String removePropertyNamespace(String propertyName) {
        String result = propertyName;
        if (propertyName.startsWith(this.getClass().getName())) {
            result = result.substring(this.getClass().getName().length() + 1);
        }
        if (result.endsWith("_converted")) {
            result = result.substring(0, result.length() - "_converted".length() - 1);
        }
        return result;
    }

    @Override
    public boolean supportsRetrieval() {
        return true;
    }

    @Override
    public boolean supportsSubmission() {
        return true;
    }

    public String toString() {
        return "Evaluation [property=" + this.property + "]";
    }
}

