/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.impl;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.exception.RewriteException;
import org.ocpsoft.rewrite.servlet.event.BaseRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpInboundServletRewrite;
import org.ocpsoft.rewrite.servlet.impl.BaseHttpRewrite;
import org.ocpsoft.urlbuilder.Address;

public class HttpInboundRewriteImpl
extends BaseHttpRewrite
implements HttpInboundServletRewrite {
    Logger log = Logger.getLogger(HttpInboundRewriteImpl.class);

    public HttpInboundRewriteImpl(HttpServletRequest request, HttpServletResponse response) {
        super(request, response);
    }

    @Override
    public void redirectTemporary(String location) {
        this.log.debug("Temporary Redirect (302) requested: [" + location + "]");
        HttpServletResponse response = (HttpServletResponse)this.getResponse();
        if (response.isCommitted()) {
            throw new IllegalStateException("Response is already committed. Cannot issue redirect.");
        }
        this.dispatchResource = this.encodeRedirectUrl(response, location);
        this.flow = BaseRewrite.Flow.REDIRECT_TEMPORARY;
    }

    @Override
    public void redirectPermanent(String location) {
        this.log.debug("Permanent Redirect (301) requested: [" + location + "]");
        HttpServletResponse response = (HttpServletResponse)this.getResponse();
        if (response.isCommitted()) {
            throw new IllegalStateException("Response is already committed. Cannot issue redirect.");
        }
        this.dispatchResource = this.encodeRedirectUrl(response, location);
        this.flow = BaseRewrite.Flow.REDIRECT_PERMANENT;
    }

    private String encodeRedirectUrl(HttpServletResponse response, String url) {
        return response.encodeRedirectURL(url);
    }

    @Override
    public void sendStatusCode(int code) {
        HttpServletResponse response = (HttpServletResponse)this.getResponse();
        if (response.isCommitted()) {
            throw new IllegalStateException("Response is already committed. Cannot send codes.");
        }
        try {
            response.setStatus(code);
            response.flushBuffer();
            this.abort();
        }
        catch (IOException e) {
            throw new RewriteException("Could not send HTTP status code.", e);
        }
    }

    @Override
    public void sendStatusCode(int code, String message) {
        try {
            ((HttpServletResponse)this.getResponse()).getWriter().write("<h1>" + message + "</h1>");
            this.sendStatusCode(code);
        }
        catch (IOException e) {
            throw new RewriteException("Could not send HTTP status code.", e);
        }
    }

    @Override
    public void sendErrorCode(int code) {
        this.sendErrorCode(code, null);
    }

    @Override
    public void sendErrorCode(int code, String message) {
        HttpServletResponse response = (HttpServletResponse)this.getResponse();
        if (response.isCommitted()) {
            throw new IllegalStateException("Response is already committed. Cannot send codes.");
        }
        try {
            if (message == null) {
                response.sendError(code);
            } else {
                response.sendError(code, message);
            }
            this.abort();
        }
        catch (IOException e) {
            throw new RewriteException("Could not send HTTP error code.", e);
        }
    }

    @Override
    public Address getAddress() {
        return this.getInboundAddress();
    }

    @Override
    public String toString() {
        return "InboundRewrite [" + ((HttpServletRequest)this.getRequest()).getMethod() + " url=" + this.getAddress() + ", flow=" + (Object)((Object)this.getFlow()) + ", dispatchResource=" + this.getDispatchResource() + "]";
    }
}

