/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.ParameterizedPatternParserParameter;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.config.IRequestParameter;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public class RequestParameter
extends HttpCondition
implements IRequestParameter {
    private final ParameterizedPatternParser name;
    private final ParameterizedPatternParser value;
    private final ParameterStore<IRequestParameter.RequestParameterParameter> parameters = new ParameterStore();

    private RequestParameter(String name, String value) {
        Assert.notNull(name, "Header name pattern cannot be null.");
        Assert.notNull(value, "Header value pattern cannot be null.");
        this.name = new RegexParameterizedPatternParser(name);
        this.value = new RegexParameterizedPatternParser(value);
    }

    public static RequestParameter matches(String name, String value) {
        return new RequestParameter(name, value);
    }

    public static RequestParameter matchesAll(String name, String value) {
        return new AllRequestParameters(name, value);
    }

    public static RequestParameter exists(String name) {
        return new RequestParameter(name, "{" + RequestParameter.class.getName() + "_value}");
    }

    public static RequestParameter valueExists(String value) {
        return new RequestParameter("{" + RequestParameter.class.getName() + "_name}", value);
    }

    @Override
    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        HttpServletRequest request = (HttpServletRequest)event.getRequest();
        for (String parameter : Collections.list(request.getParameterNames())) {
            if (!this.name.matches(event, context, parameter) || !this.matchesValue(event, context, request, parameter)) continue;
            HashMap<ParameterizedPatternParserParameter, String[]> parameterValues = new HashMap<ParameterizedPatternParserParameter, String[]>();
            parameterValues.putAll(this.name.parse(event, context, parameter));
            parameterValues.putAll(this.value.parse(event, context, request.getParameter(parameter)));
            for (ParameterizedPatternParserParameter capture : parameterValues.keySet()) {
                if (Bindings.enqueueSubmission(event, context, capture, parameterValues.get(capture))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean matchesValue(Rewrite event, EvaluationContext context, HttpServletRequest request, String header) {
        for (String contents : Arrays.asList(request.getParameterValues(header))) {
            if (!this.value.matches(event, context, contents)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IRequestParameter.RequestParameterParameter where(String param) {
        ParameterizedPatternParserParameter valueParam;
        ParameterizedPatternParserParameter nameParam = this.name.getParameterNames().contains(param) ? (ParameterizedPatternParserParameter)this.name.getParameter(param) : null;
        ParameterizedPatternParserParameter parameterizedPatternParserParameter = valueParam = this.value.getParameterNames().contains(param) ? (ParameterizedPatternParserParameter)this.value.getParameter(param) : null;
        if (nameParam != null || valueParam != null) {
            return this.parameters.where(param, new IRequestParameter.RequestParameterParameter(this, nameParam, valueParam));
        }
        throw new IllegalArgumentException("No such parameter [" + param + "] exists.");
    }

    @Override
    public IRequestParameter.RequestParameterParameter where(String param, Binding binding) {
        return this.where(param, binding);
    }

    public ParameterizedPatternParser getNameExpression() {
        return this.name;
    }

    public ParameterizedPatternParser getValueExpression() {
        return this.value;
    }

    public String toString() {
        return "RequestParameter [name=" + this.name + ", value=" + this.value + ", parameters=" + this.parameters + "]";
    }

    public static class AllRequestParameters
    extends RequestParameter {
        public AllRequestParameters(String name, String value) {
            super(name, value);
        }

        @Override
        public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
            HttpServletRequest request = (HttpServletRequest)event.getRequest();
            for (String name : Collections.list(request.getParameterNames())) {
                if (!this.getNameExpression().matches(event, context, name) || !this.matchesValues(event, context, request, name)) continue;
                Map<ParameterizedPatternParserParameter, String[]> parameters = this.getNameExpression().parse(event, context, name);
                parameters.putAll(this.getValueExpression().parse(event, context, name));
                for (ParameterizedPatternParserParameter capture : parameters.keySet()) {
                    if (Bindings.enqueueSubmission(event, context, capture, parameters.get(capture))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private boolean matchesValues(Rewrite event, EvaluationContext context, HttpServletRequest request, String name) {
            for (String contents : Arrays.asList(request.getParameterValues(name))) {
                if (this.getValueExpression().matches(event, context, contents)) continue;
                return false;
            }
            return true;
        }
    }
}

