/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterizedPatternBuilderParameter;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternBuilder;
import org.ocpsoft.rewrite.param.Transformations;
import org.ocpsoft.rewrite.servlet.config.HttpOperation;
import org.ocpsoft.rewrite.servlet.config.IRedirect;
import org.ocpsoft.rewrite.servlet.http.event.HttpInboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public class Redirect
extends HttpOperation
implements IRedirect {
    private final RedirectType type;
    private final RegexParameterizedPatternBuilder location;
    private final ParameterStore<IRedirect.RedirectParameter> parameters = new ParameterStore();

    private Redirect(String location, RedirectType type) {
        this.location = new RegexParameterizedPatternBuilder("[^/]+", location);
        this.type = type;
        for (ParameterizedPatternBuilderParameter parameter : this.location.getParameterMap().values()) {
            ((IRedirect.RedirectParameter)this.where(parameter.getName()).bindsTo(Evaluation.property(parameter.getName()))).transformedBy(Transformations.encodePath());
        }
    }

    @Override
    public void performHttp(HttpServletRewrite event, EvaluationContext context) {
        if (event instanceof HttpInboundServletRewrite) {
            String target = this.location.build(event, context, this.parameters);
            switch (this.type) {
                case PERMANENT: {
                    ((HttpInboundServletRewrite)event).redirectPermanent(target);
                    break;
                }
                case TEMPORARY: {
                    ((HttpInboundServletRewrite)event).redirectTemporary(target);
                    break;
                }
            }
        }
    }

    public static Redirect permanent(String location) {
        return new Redirect(location, RedirectType.PERMANENT);
    }

    public static Redirect temporary(String location) {
        return new Redirect(location, RedirectType.TEMPORARY);
    }

    @Override
    public IRedirect.RedirectParameter where(String param) {
        return this.parameters.where(param, new IRedirect.RedirectParameter(this, this.location.getParameter(param)));
    }

    @Override
    public IRedirect.RedirectParameter where(String param, Binding binding) {
        return (IRedirect.RedirectParameter)this.where(param).bindsTo(binding);
    }

    @Override
    public RegexParameterizedPatternBuilder getTargetExpression() {
        return this.location;
    }

    public String toString() {
        return "Redirect [type=" + (Object)((Object)this.type) + ", location=" + this.location + ", parameters=" + this.parameters + "]";
    }

    private static enum RedirectType {
        PERMANENT,
        TEMPORARY;

    }
}

