/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.rewrite.bind.Bindable;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.bind.DefaultBindable;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public class DispatchType
extends HttpCondition
implements Bindable<DispatchType> {
    private final DispatcherType type;
    private final DefaultBindable<?> bindable = new DefaultBindable();

    private DispatchType(DispatcherType type) {
        this.type = type;
    }

    @Override
    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        if (this.type.equals((Object)((HttpServletRequest)event.getRequest()).getDispatcherType())) {
            Bindings.enqueueSubmission(event, context, this.bindable, this.type);
            return true;
        }
        return false;
    }

    public static DispatchType isForward() {
        return new DispatchType(DispatcherType.FORWARD);
    }

    public static DispatchType isRequest() {
        return new DispatchType(DispatcherType.REQUEST);
    }

    public static DispatchType isError() {
        return new DispatchType(DispatcherType.ERROR);
    }

    public static DispatchType isAsync() {
        return new DispatchType(DispatcherType.ASYNC);
    }

    public static DispatchType isInclude() {
        return new DispatchType(DispatcherType.INCLUDE);
    }

    public String toString() {
        return this.type == null ? "unknown" : this.type.toString();
    }

    @Override
    public DispatchType bindsTo(Binding binding) {
        this.bindable.bindsTo(binding);
        return this;
    }

    @Override
    public List<Binding> getBindings() {
        return this.bindable.getBindings();
    }
}

