/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.param;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Bindable;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.bind.DefaultBindable;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterizedPatternBuilder;
import org.ocpsoft.rewrite.param.ParameterizedPatternBuilderParameter;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.param.Transform;
import org.ocpsoft.rewrite.util.Maps;
import org.ocpsoft.rewrite.util.ParseTools;

public class RegexParameterizedPatternBuilder
implements ParameterizedPatternBuilder {
    private static final String DEFAULT_PARAMETER_PATTERN = ".*";
    private String pattern;
    private final char[] chars;
    private final List<RegexGroup> groups = new ArrayList<RegexGroup>();
    private final ParameterStore<ParameterizedPatternBuilderParameter> parameters = new ParameterStore();
    private RegexParameterizedPatternParser parser = null;

    RegexParameterizedPatternBuilder(String pattern, RegexParameterizedPatternParser parser) {
        this(pattern);
        this.parser = parser;
    }

    public RegexParameterizedPatternBuilder(String pattern) {
        this(ParseTools.CaptureType.BRACE, DEFAULT_PARAMETER_PATTERN, pattern);
    }

    public RegexParameterizedPatternBuilder(String parameterPattern, String pattern) {
        this(ParseTools.CaptureType.BRACE, parameterPattern, pattern);
    }

    public RegexParameterizedPatternBuilder(ParseTools.CaptureType type, String pattern) {
        this(type, DEFAULT_PARAMETER_PATTERN, pattern);
    }

    public RegexParameterizedPatternBuilder(ParseTools.CaptureType type, String parameterPattern, String pattern) {
        Assert.notNull(pattern, "Pattern must not be null");
        this.pattern = pattern;
        this.chars = pattern.toCharArray();
        if (this.chars.length > 0) {
            int parameterIndex = 0;
            block3: for (int cursor = 0; cursor < this.chars.length; ++cursor) {
                switch (this.chars[cursor]) {
                    case '{': {
                        int startPos = cursor;
                        ParseTools.CapturingGroup group = ParseTools.balancedCapture(this.chars, startPos, this.chars.length - 1, type);
                        cursor = group.getEnd();
                        this.groups.add(new RegexGroup(group, parameterIndex++));
                        String parameterName = new String(group.getCaptured());
                        this.parameters.where(parameterName, (ParameterizedPatternBuilderParameter)new ParameterizedPatternBuilderParameter(this, parameterName).matches(parameterPattern));
                        continue block3;
                    }
                }
            }
        }
    }

    @Override
    public Map<String, ParameterizedPatternBuilderParameter> getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public String build(Rewrite event, EvaluationContext context, final Map<String, ? extends Bindable<?>> parameters) {
        return this.build(this.extractBoundValues(event, context, new Transposition(){

            @Override
            public Bindable<?> getBindable(RegexGroup capture) {
                Bindable bindable = (Bindable)parameters.get(capture.getName());
                if (bindable != null) {
                    return bindable;
                }
                return new DefaultBindable().bindsTo(Evaluation.property(capture.getName()));
            }
        }));
    }

    public String build(Rewrite event, EvaluationContext context) {
        return this.build(this.extractBoundValues(event, context, new Transposition(){

            @Override
            public Bindable<?> getBindable(RegexGroup capture) {
                return new DefaultBindable().bindsTo(Evaluation.property(capture.getName()));
            }
        }));
    }

    @Override
    public String build(Object ... values) {
        if (values == null || this.groups.size() != values.length) {
            throw new IllegalArgumentException("Must supply [" + this.groups.size() + "] values to build output string.");
        }
        StringBuilder builder = new StringBuilder();
        ParseTools.CapturingGroup last = null;
        int index = 0;
        for (RegexGroup param : this.groups) {
            ParseTools.CapturingGroup capture = param.getCapture();
            if (last != null && last.getEnd() < capture.getStart()) {
                builder.append(Arrays.copyOfRange(this.chars, last.getEnd() + 1, capture.getStart()));
            } else if (last == null && capture.getStart() > 0) {
                builder.append(Arrays.copyOfRange(this.chars, 0, capture.getStart()));
            }
            builder.append(values[index++]);
            last = capture;
        }
        if (last != null && last.getEnd() < this.chars.length) {
            builder.append(Arrays.copyOfRange(this.chars, last.getEnd() + 1, this.chars.length));
        } else if (last == null) {
            builder.append(this.chars);
        }
        return builder.toString();
    }

    @Override
    public String build(Map<String, List<String>> values) {
        if (values == null || this.groups.size() != values.size()) {
            throw new IllegalArgumentException("Must supply [" + this.groups.size() + "] values to build output string.");
        }
        StringBuilder builder = new StringBuilder();
        ParseTools.CapturingGroup last = null;
        LinkedHashMap<String, Integer> pointers = new LinkedHashMap<String, Integer>();
        for (RegexGroup param : this.groups) {
            ParseTools.CapturingGroup capture = param.getCapture();
            if (last != null && last.getEnd() < capture.getStart()) {
                builder.append(Arrays.copyOfRange(this.chars, last.getEnd() + 1, capture.getStart()));
            } else if (last == null && capture.getStart() > 0) {
                builder.append(Arrays.copyOfRange(this.chars, 0, capture.getStart()));
            }
            String name = param.getName();
            int index = pointers.get(name) == null ? 0 : (Integer)pointers.get(name);
            builder.append((String)Maps.getListValue(values, name, index));
            pointers.put(name, index++);
            last = capture;
        }
        if (last != null && last.getEnd() < this.chars.length) {
            builder.append(Arrays.copyOfRange(this.chars, last.getEnd() + 1, this.chars.length));
        } else if (last == null) {
            builder.append(this.chars);
        }
        return builder.toString();
    }

    private String applyTransforms(Rewrite event, EvaluationContext context, ParameterizedPatternBuilderParameter param, String value) {
        String result = value;
        for (Transform t : param.getTransforms()) {
            result = t.transform(event, context, value);
        }
        return result;
    }

    private Map<String, List<String>> extractBoundValues(Rewrite event, EvaluationContext context, Transposition transpose) {
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        for (RegexGroup group : this.groups) {
            List<Object> values = Bindings.performRetrieval(event, context, transpose.getBindable(group));
            for (Object boundValue : values) {
                String name = group.getName();
                if (boundValue.getClass().isArray()) {
                    for (Object temp : (Object[])boundValue) {
                        Maps.addListValue(result, name, this.applyTransforms(event, context, (ParameterizedPatternBuilderParameter)this.parameters.get(name), temp == null ? null : temp.toString()));
                    }
                    continue;
                }
                Maps.addListValue(result, name, this.applyTransforms(event, context, (ParameterizedPatternBuilderParameter)this.parameters.get(name), boundValue == null ? null : boundValue.toString()));
            }
        }
        return result;
    }

    @Override
    public List<String> getParameterNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (RegexGroup group : this.groups) {
            result.add(group.getName());
        }
        return result;
    }

    public String toString() {
        return new String(this.chars);
    }

    @Override
    public ParameterizedPatternBuilderParameter where(String param) {
        return (ParameterizedPatternBuilderParameter)this.parameters.get(param);
    }

    @Override
    public ParameterizedPatternBuilderParameter where(String param, Binding binding) {
        return (ParameterizedPatternBuilderParameter)this.where(param).bindsTo(binding);
    }

    @Override
    public ParameterizedPatternBuilderParameter getParameter(String param) {
        return this.where(param);
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public ParameterizedPatternParser getParser() {
        if (this.parser == null) {
            this.parser = new RegexParameterizedPatternParser(this.pattern, this);
        }
        return this.parser;
    }

    class RegexGroup {
        private final ParseTools.CapturingGroup capture;
        private final int index;

        public RegexGroup(ParseTools.CapturingGroup capture, int index) {
            this.capture = capture;
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return new String(this.capture.getCaptured());
        }

        public ParseTools.CapturingGroup getCapture() {
            return this.capture;
        }

        public String toString() {
            return "RegexParameter [name=" + this.getName() + ", capture=" + this.capture + "]";
        }
    }

    private static interface Transposition {
        public Bindable<?> getBindable(RegexGroup var1);
    }
}

