/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.config;

import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.config.OperationBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;

public abstract class DefaultOperationBuilder
implements OperationBuilder {
    public static OperationBuilder create() {
        return new DefaultOperationBuilder(){

            @Override
            public void perform(Rewrite event, EvaluationContext context) {
            }
        };
    }

    public static OperationBuilder wrap(Operation operation) {
        if (operation == null) {
            return DefaultOperationBuilder.create();
        }
        return new CompositeOperation(DefaultOperationBuilder.create(), operation);
    }

    @Override
    public OperationBuilder and(Operation other) {
        if (other == null) {
            return this;
        }
        return new CompositeOperation(this, other);
    }

    private static class CompositeOperation
    extends DefaultOperationBuilder {
        private final Operation left;
        private final Operation right;

        public CompositeOperation(Operation left, Operation right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public void perform(Rewrite event, EvaluationContext context) {
            this.left.perform(event, context);
            this.right.perform(event, context);
        }
    }
}

