/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.bind;

import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Converter;
import org.ocpsoft.rewrite.bind.DefaultConverter;
import org.ocpsoft.rewrite.bind.DefaultValidator;
import org.ocpsoft.rewrite.bind.HasConverter;
import org.ocpsoft.rewrite.bind.HasValidator;
import org.ocpsoft.rewrite.bind.Retrieval;
import org.ocpsoft.rewrite.bind.Submission;
import org.ocpsoft.rewrite.bind.Validator;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.util.ValueHolderUtil;

public abstract class BindingBuilder<C extends BindingBuilder<C, T>, T>
implements Binding,
Retrieval,
Submission,
HasValidator<C>,
HasConverter<C> {
    private Converter<?> converter = new DefaultConverter();
    private Validator<?> validator = new DefaultValidator();

    @Override
    public <X extends Converter<?>> C convertedBy(Class<X> type) {
        this.converter = ValueHolderUtil.resolveConverter(type);
        return (C)this;
    }

    @Override
    public C convertedBy(Converter<?> converter) {
        this.converter = converter;
        return (C)this;
    }

    @Override
    public Converter<?> getConverter() {
        return this.converter;
    }

    @Override
    public <X extends Validator<?>> C validatedBy(Class<X> type) {
        this.validator = ValueHolderUtil.resolveValidator(type);
        return (C)this;
    }

    @Override
    public C validatedBy(Validator<?> validator) {
        this.validator = validator;
        return (C)this;
    }

    @Override
    public Validator<?> getValidator() {
        return this.validator;
    }

    @Override
    public Object convert(Rewrite event, EvaluationContext context, Object value) {
        return ValueHolderUtil.convert(event, context, this.converter, value);
    }

    @Override
    public boolean validate(Rewrite event, EvaluationContext context, Object value) {
        return ValueHolderUtil.validates(event, context, this.validator, value);
    }
}

