/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.bind;

import java.util.ArrayList;
import java.util.List;
import org.ocpsoft.rewrite.bind.parse.CapturingGroup;
import org.ocpsoft.rewrite.param.Constrainable;
import org.ocpsoft.rewrite.param.Constraint;
import org.ocpsoft.rewrite.param.Transform;
import org.ocpsoft.rewrite.param.Transformable;

public class RegexCapture
implements Constrainable<RegexCapture, String>,
Transformable<RegexCapture, String> {
    private String pattern;
    private final CapturingGroup capture;
    private final int index;
    private final List<Transform<String>> transforms = new ArrayList<Transform<String>>();
    private final List<Constraint<String>> constraints = new ArrayList<Constraint<String>>();

    public RegexCapture(CapturingGroup capture, int index) {
        this.capture = capture;
        this.index = index;
    }

    @Override
    public RegexCapture constrainedBy(Constraint<String> constraint) {
        this.constraints.add(constraint);
        return this;
    }

    @Override
    public List<Constraint<String>> getConstraints() {
        return this.constraints;
    }

    @Override
    public RegexCapture transformedBy(Transform<String> transform) {
        this.transforms.add(transform);
        return this;
    }

    @Override
    public List<Transform<String>> getTransforms() {
        return this.transforms;
    }

    public void matches(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return new String(this.capture.getCaptured());
    }

    public CapturingGroup getCapture() {
        return this.capture;
    }

    public String toString() {
        return "RegexParameter [name=" + this.getName() + ", capture=" + this.capture + "]";
    }
}

