/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.bind.ParameterizedPattern;
import org.ocpsoft.rewrite.bind.RegexConditionParameterBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ConditionParameterBuilder;
import org.ocpsoft.rewrite.param.ParameterizedCondition;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public class Header
extends HttpCondition
implements ParameterizedCondition<ConditionParameterBuilder<RegexConditionParameterBuilder, String>, String> {
    private final ParameterizedPattern name;
    private final ParameterizedPattern value;

    private Header(String name, String value) {
        Assert.notNull(name, "Header name pattern cannot be null.");
        Assert.notNull(value, "Header value pattern cannot be null.");
        this.name = new ParameterizedPattern(name);
        this.value = new ParameterizedPattern(value);
    }

    public static Header matches(String name, String value) {
        return new Header(name, value);
    }

    public static Header exists(String name) {
        return new Header(name, "{" + Header.class.getName() + "_value}");
    }

    public static Header valueExists(String value) {
        return new Header("{" + Header.class.getName() + "_name}", value);
    }

    @Override
    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        HttpServletRequest request = (HttpServletRequest)event.getRequest();
        for (String header : Collections.list(request.getHeaderNames())) {
            if (!this.name.matches(event, context, header) || !this.matchesValue(event, context, request, header)) continue;
            Map<ParameterizedPattern.RegexParameter, String[]> parameters = this.name.parse(event, context, header);
            parameters = this.value.parse(event, context, header);
            if (!Bindings.enqueuePreOperationSubmissions(event, context, parameters) || !Bindings.enqueuePreOperationSubmissions(event, context, parameters)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesValue(Rewrite event, EvaluationContext context, HttpServletRequest request, String header) {
        for (String contents : Collections.list(request.getHeaders(header))) {
            if (!this.value.matches(event, context, contents)) continue;
            return true;
        }
        return false;
    }

    @Override
    public RegexConditionParameterBuilder where(String param) {
        return new RegexConditionParameterBuilder(this, new ParameterizedPattern.RegexParameter[]{this.name.getParameter(param), this.value.getParameter(param)});
    }

    @Override
    public RegexConditionParameterBuilder where(String param, String pattern) {
        return this.where(param).matches(pattern);
    }

    @Override
    public RegexConditionParameterBuilder where(String param, String pattern, Binding binding) {
        return (RegexConditionParameterBuilder)this.where(param, pattern).bindsTo(binding);
    }

    @Override
    public RegexConditionParameterBuilder where(String param, Binding binding) {
        return this.where(param, binding);
    }
}

