/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.param;

import java.util.ArrayList;
import java.util.List;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.config.OperationBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.Constraint;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterizedOperation;
import org.ocpsoft.rewrite.param.Transform;

public class OperationParameterBuilder<P extends OperationParameterBuilder<P, T>, T>
implements ParameterizedOperation<OperationParameterBuilder<P, T>, T> {
    private final ParameterizedOperation<OperationParameterBuilder<P, T>, T> parent;
    private final List<Parameter<T>> parameters;

    public OperationParameterBuilder(ParameterizedOperation<OperationParameterBuilder<P, T>, T> parent, Parameter<T> ... parameters) {
        this.parent = parent;
        this.parameters = new ArrayList<Parameter<T>>();
        for (Parameter<T> parameter : parameters) {
            if (parameter == null) continue;
            this.parameters.add(parameter);
        }
    }

    public P constrainedBy(Constraint<T> constraint) {
        for (Parameter<T> parameter : this.parameters) {
            parameter.constrainedBy(constraint);
        }
        return (P)this;
    }

    public P transformedBy(Transform<T> transform) {
        for (Parameter<T> parameter : this.parameters) {
            parameter.transformedBy(transform);
        }
        return (P)this;
    }

    public P bindsTo(Binding binding) {
        for (Parameter<T> parameter : this.parameters) {
            parameter.bindsTo(binding);
        }
        return (P)this;
    }

    @Override
    public P where(String param) {
        return (P)((OperationParameterBuilder)this.parent.where(param));
    }

    @Override
    public P where(String param, T pattern) {
        return (P)((OperationParameterBuilder)this.parent.where(param, pattern));
    }

    @Override
    public P where(String param, T pattern, Binding binding) {
        return (P)((OperationParameterBuilder)this.parent.where(param, pattern, binding));
    }

    @Override
    public P where(String param, Binding binding) {
        return (P)((OperationParameterBuilder)this.parent.where(param, binding));
    }

    @Override
    public OperationBuilder and(Operation other) {
        return this.parent.and(other);
    }

    @Override
    public void perform(Rewrite event, EvaluationContext context) {
        this.parent.perform(event, context);
    }
}

