/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.bind;

import java.util.List;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.common.util.Iterators;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.bind.BindingBuilder;
import org.ocpsoft.rewrite.bind.Converter;
import org.ocpsoft.rewrite.bind.RetrievalBuilder;
import org.ocpsoft.rewrite.bind.SubmissionBuilder;
import org.ocpsoft.rewrite.bind.Validator;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.exception.RewriteException;
import org.ocpsoft.rewrite.exception.UnsupportedEvaluationException;
import org.ocpsoft.rewrite.spi.ExpressionLanguageProvider;

public abstract class El
extends BindingBuilder {
    private static final Logger log = Logger.getLogger(El.class);
    private static List<ExpressionLanguageProvider> providers;

    public static BindingBuilder methodBinding(String retrieve, String submit) {
        return new ElMethod(retrieve, submit);
    }

    public static RetrievalBuilder retrievalMethod(String expression) {
        return new ElMethod(expression, null);
    }

    public static RetrievalBuilder retrievalMethod(String expression, Class<? extends Converter<?>> converterType) {
        ElMethod el = new ElMethod(expression, null);
        el.convertedBy((Class)converterType);
        return el;
    }

    public static SubmissionBuilder submissionMethod(String expression) {
        return new ElMethod(null, expression);
    }

    public static SubmissionBuilder submissionMethod(String expression, Class<? extends Converter<?>> converterType) {
        ElMethod el = new ElMethod(null, expression);
        el.convertedBy((Class)converterType);
        return el;
    }

    public static SubmissionBuilder submissionMethod(String expression, Class<? extends Converter<?>> converterType, Class<? extends Validator<?>> validatorType) {
        ElMethod el = new ElMethod(null, expression);
        el.convertedBy((Class)converterType);
        el.validatedBy((Class)validatorType);
        return el;
    }

    public static BindingBuilder property(String expression) {
        return new ElProperty(expression);
    }

    public static BindingBuilder property(String expression, Class<? extends Converter<?>> type) {
        ElProperty el = new ElProperty(expression);
        el.convertedBy((Class)type);
        return el;
    }

    public static BindingBuilder property(String expression, Class<? extends Converter<?>> converterType, Class<? extends Validator<?>> validatorType) {
        ElProperty el = new ElProperty(expression);
        el.convertedBy((Class)converterType);
        el.validatedBy((Class)validatorType);
        return el;
    }

    private static List<ExpressionLanguageProvider> getProviders() {
        if (providers == null) {
            ServiceLoader serviceProviders = ServiceLoader.load(ExpressionLanguageProvider.class);
            providers = Iterators.asList(serviceProviders.iterator());
        }
        return providers;
    }

    public static class ElProperty
    extends El {
        private final String expression;

        public ElProperty(String expression) {
            this.expression = expression;
        }

        @Override
        public Object retrieve(Rewrite event, EvaluationContext context) {
            ServiceLoader providers = ServiceLoader.load(ExpressionLanguageProvider.class);
            Object value = null;
            for (ExpressionLanguageProvider provider : providers) {
                try {
                    value = provider.retrieveValue(this.expression);
                    break;
                }
                catch (UnsupportedEvaluationException e) {
                    log.debug("El provider [" + provider.getClass().getName() + "] could not extract value from property [" + this.expression + "]", e);
                }
                catch (Exception e) {
                    throw new RewriteException("El provider [" + provider.getClass().getName() + "] could not extract value from property [" + this.expression + "]", e);
                }
                if (value == null) continue;
                break;
            }
            return value;
        }

        @Override
        public boolean supportsRetrieval() {
            return true;
        }

        @Override
        public boolean supportsSubmission() {
            return true;
        }

        @Override
        public Object submit(Rewrite event, EvaluationContext context, Object value) {
            ServiceLoader providers = ServiceLoader.load(ExpressionLanguageProvider.class);
            if (!providers.iterator().hasNext()) {
                log.warn("No instances of [{}] were configured. EL support is disabled.", ExpressionLanguageProvider.class.getName());
            }
            for (ExpressionLanguageProvider provider : providers) {
                try {
                    provider.submitValue(this.expression, value);
                    break;
                }
                catch (UnsupportedEvaluationException e) {
                    log.debug("El provider [" + provider.getClass().getName() + "] could not inject property [" + this.expression + "} with value [" + value + "]", e);
                }
                catch (Exception e) {
                    throw new RewriteException("El provider [" + provider.getClass().getName() + "] could not inject property [" + this.expression + "} with value [" + value + "]", e);
                }
            }
            return null;
        }

        public String toString() {
            return "ElProperty [ " + this.expression + " ]";
        }
    }

    public static class ElMethod
    extends El {
        private final String getExpression;
        private final String setExpression;

        public ElMethod(String getExpression, String setExpression) {
            this.getExpression = getExpression;
            this.setExpression = setExpression;
        }

        @Override
        public Object retrieve(Rewrite event, EvaluationContext context) {
            ServiceLoader providers = ServiceLoader.load(ExpressionLanguageProvider.class);
            if (!this.supportsRetrieval()) {
                throw new RewriteException("Method binding expression supports submission only [" + this.setExpression + "], no value retrieval expression was defined");
            }
            Object value = null;
            for (ExpressionLanguageProvider provider : providers) {
                try {
                    return provider.evaluateMethodExpression(this.getExpression);
                }
                catch (UnsupportedEvaluationException e) {
                    log.debug("El provider [" + provider.getClass().getName() + "] could not invoke method [" + this.getExpression + "]", e);
                }
                catch (Exception e) {
                    throw new RewriteException("El provider [" + provider.getClass().getName() + "] could not retrieve value from property [" + this.getExpression + "]", e);
                }
            }
            return value;
        }

        @Override
        public Object submit(Rewrite event, EvaluationContext context, Object value) {
            if (!this.supportsSubmission()) {
                throw new RewriteException("Method binding expression supports retrieval only [" + this.getExpression + "], no value submission expression was defined");
            }
            for (ExpressionLanguageProvider provider : El.getProviders()) {
                try {
                    return provider.evaluateMethodExpression(this.setExpression, value);
                }
                catch (UnsupportedEvaluationException e) {
                    log.debug("El provider [" + provider.getClass().getName() + "] could not submit method [" + this.setExpression + "} with value [" + value + "]", e);
                }
                catch (Exception e) {
                    throw new RewriteException("El provider [" + provider.getClass().getName() + "] could not submit method [" + this.setExpression + "} with value [" + value + "]", e);
                }
            }
            return null;
        }

        @Override
        public boolean supportsRetrieval() {
            return this.getExpression != null;
        }

        @Override
        public boolean supportsSubmission() {
            return this.setExpression != null;
        }

        public String toString() {
            return "ElMethod [retrieve= [ " + this.getExpression + " }, submit= [ " + this.setExpression + " ]";
        }
    }
}

