/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.bind.ParameterizedPattern;
import org.ocpsoft.rewrite.bind.RegexConditionParameterBuilder;
import org.ocpsoft.rewrite.bind.RegexParameter;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.param.ConditionParameterBuilder;
import org.ocpsoft.rewrite.param.ParameterizedCondition;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.util.URLBuilder;

public class Domain
extends HttpCondition
implements ParameterizedCondition<ConditionParameterBuilder<RegexConditionParameterBuilder, String>, String> {
    private final ParameterizedPattern expression;

    private Domain(String pattern) {
        Assert.notNull(pattern, "Domain must not be null.");
        this.expression = new ParameterizedPattern(pattern);
        for (RegexParameter parameter : this.expression.getParameters().values()) {
            parameter.bindsTo(Evaluation.property(parameter.getName()));
        }
    }

    public static Domain matches(String pattern) {
        return new Domain(pattern);
    }

    @Override
    public RegexConditionParameterBuilder where(String param) {
        return new RegexConditionParameterBuilder(this, this.expression.getParameter(param));
    }

    @Override
    public RegexConditionParameterBuilder where(String param, String pattern) {
        return this.where(param).matches(pattern);
    }

    @Override
    public RegexConditionParameterBuilder where(String param, String pattern, Binding binding) {
        return (RegexConditionParameterBuilder)this.where(param, pattern).bindsTo(binding);
    }

    @Override
    public RegexConditionParameterBuilder where(String param, Binding binding) {
        return (RegexConditionParameterBuilder)this.where(param).bindsTo(binding);
    }

    @Override
    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        Map<RegexParameter, String[]> parameters;
        String hostName = null;
        if (event instanceof HttpOutboundServletRewrite) {
            String url = event.getURL();
            URLBuilder builder = URLBuilder.createFrom(url);
            hostName = builder.toURI().getHost();
            if (hostName == null) {
                hostName = ((HttpServletRequest)event.getRequest()).getServerName();
            }
        } else {
            hostName = ((HttpServletRequest)event.getRequest()).getServerName();
        }
        return hostName != null && this.expression.matches(event, context, hostName) && Bindings.enqueuePreOperationSubmissions(event, context, parameters = this.expression.parse(event, context, hostName));
    }

    public ParameterizedPattern getExpression() {
        return this.expression;
    }

    public String toString() {
        return this.expression.toString();
    }
}

