/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config.bind;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.rewrite.bind.BindingBuilder;
import org.ocpsoft.rewrite.bind.Converter;
import org.ocpsoft.rewrite.bind.Validator;
import org.ocpsoft.rewrite.bind.util.Maps;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.servlet.event.ServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.impl.HttpRewriteWrappedRequest;

public abstract class Request
extends BindingBuilder {
    public static BindingBuilder attribute(String property) {
        return new RequestAttributeBinding(property);
    }

    public static BindingBuilder attribute(String property, Class<? extends Converter<?>> type) {
        return Request.attribute(property).convertedBy((Class)type);
    }

    public static BindingBuilder attribute(String property, Class<Converter<?>> converterType, Class<? extends Validator<?>> validatorType) {
        return Request.attribute(property, converterType).validatedBy((Class)validatorType);
    }

    public static BindingBuilder parameter(String property) {
        return new RequestParameterBinding(property);
    }

    public static BindingBuilder parameter(String property, Class<? extends Converter<?>> type) {
        return Request.parameter(property).convertedBy((Class)type);
    }

    public static BindingBuilder parameter(String property, Class<Converter<?>> converterType, Class<? extends Validator<?>> validatorType) {
        return Request.parameter(property, converterType).validatedBy((Class)validatorType);
    }

    @Override
    public boolean supportsRetrieval() {
        return true;
    }

    @Override
    public boolean supportsSubmission() {
        return true;
    }

    private static class RequestAttributeBinding
    extends Request {
        private final String parameter;

        public RequestAttributeBinding(String attribute) {
            this.parameter = attribute;
        }

        @Override
        public Object submit(Rewrite event, EvaluationContext context, Object value) {
            ((HttpServletRequest)((HttpServletRewrite)event).getRequest()).setAttribute(this.parameter, value);
            return null;
        }

        @Override
        public Object retrieve(Rewrite event, EvaluationContext context) {
            if (event instanceof HttpServletRewrite) {
                return ((HttpServletRequest)((HttpServletRewrite)event).getRequest()).getParameter(this.parameter);
            }
            return null;
        }
    }

    private static class RequestParameterBinding
    extends Request {
        private final String parameter;

        public RequestParameterBinding(String parameter) {
            this.parameter = parameter;
        }

        @Override
        public Object submit(Rewrite event, EvaluationContext context, Object value) {
            HttpRewriteWrappedRequest wrapper = (HttpRewriteWrappedRequest)((Object)((HttpServletRequest)((HttpServletRewrite)event).getRequest()).getAttribute(HttpRewriteWrappedRequest.class.getName()));
            Map<String, String[]> modifiableParameters = wrapper.getModifiableParameters();
            if (value.getClass().isArray()) {
                Object[] values;
                for (Object object : values = (Object[])value) {
                    Maps.addArrayValue(modifiableParameters, this.parameter, object.toString());
                }
            } else {
                Maps.addArrayValue(modifiableParameters, this.parameter, value.toString());
            }
            return null;
        }

        @Override
        public Object retrieve(Rewrite event, EvaluationContext context) {
            if (event instanceof ServletRewrite) {
                return ((HttpServletRequest)((HttpServletRewrite)event).getRequest()).getParameter(this.parameter);
            }
            return null;
        }
    }
}

