/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.bind.ParameterizedPattern;
import org.ocpsoft.rewrite.bind.RegexOperationParameterBuilder;
import org.ocpsoft.rewrite.bind.RegexParameter;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.param.OperationParameterBuilder;
import org.ocpsoft.rewrite.param.ParameterizedOperation;
import org.ocpsoft.rewrite.servlet.config.HttpOperation;
import org.ocpsoft.rewrite.servlet.http.event.HttpInboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public class Redirect
extends HttpOperation
implements ParameterizedOperation<OperationParameterBuilder<RegexOperationParameterBuilder, String>, String> {
    private final RedirectType type;
    private final ParameterizedPattern location;

    private Redirect(String location, RedirectType type) {
        this.location = new ParameterizedPattern("[^/]+", location);
        for (RegexParameter parameter : this.location.getParameters().values()) {
            parameter.bindsTo(Evaluation.property(parameter.getName()));
        }
        this.type = type;
    }

    @Override
    public void performHttp(HttpServletRewrite event, EvaluationContext context) {
        if (event instanceof HttpInboundServletRewrite) {
            String target = this.location.build(event, context);
            switch (this.type) {
                case PERMANENT: {
                    ((HttpInboundServletRewrite)event).redirectPermanent(target);
                    break;
                }
                case TEMPORARY: {
                    ((HttpInboundServletRewrite)event).redirectTemporary(target);
                    break;
                }
            }
        }
    }

    public static Redirect permanent(String location) {
        return new Redirect(location, RedirectType.PERMANENT);
    }

    public static Redirect temporary(String location) {
        return new Redirect(location, RedirectType.TEMPORARY);
    }

    @Override
    public RegexOperationParameterBuilder where(String param) {
        return new RegexOperationParameterBuilder(this, this.location.getParameter(param));
    }

    @Override
    public RegexOperationParameterBuilder where(String param, String pattern) {
        return this.where(param).matches(pattern);
    }

    @Override
    public RegexOperationParameterBuilder where(String param, String pattern, Binding binding) {
        return (RegexOperationParameterBuilder)this.where(param, pattern).bindsTo(binding);
    }

    @Override
    public RegexOperationParameterBuilder where(String param, Binding binding) {
        return (RegexOperationParameterBuilder)this.where(param).bindsTo(binding);
    }

    private static enum RedirectType {
        PERMANENT,
        TEMPORARY;

    }
}

