/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.faces.annotation.handler;

import jakarta.faces.event.PhaseId;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.ocpsoft.rewrite.annotation.api.ClassContext;
import org.ocpsoft.rewrite.annotation.api.FieldContext;
import org.ocpsoft.rewrite.annotation.api.HandlerChain;
import org.ocpsoft.rewrite.annotation.api.MethodContext;
import org.ocpsoft.rewrite.annotation.spi.AnnotationHandler;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Submission;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.exception.RewriteException;
import org.ocpsoft.rewrite.faces.annotation.Deferred;
import org.ocpsoft.rewrite.faces.annotation.Phase;
import org.ocpsoft.rewrite.faces.annotation.handler.DeferredConverter;
import org.ocpsoft.rewrite.faces.annotation.handler.DeferredValidator;
import org.ocpsoft.rewrite.faces.config.PhaseBinding;
import org.ocpsoft.rewrite.faces.config.PhaseOperation;
import org.ocpsoft.rewrite.param.Converter;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterConfiguration;
import org.ocpsoft.rewrite.param.Validator;

public class DeferredHandler
implements AnnotationHandler<Deferred> {
    public Class<Deferred> handles() {
        return Deferred.class;
    }

    public int priority() {
        return 210;
    }

    public void process(ClassContext context, Deferred annotation, HandlerChain chain) {
        if (context instanceof FieldContext) {
            Binding binding;
            Field field = ((FieldContext)context).getJavaField();
            Parameter parameter = (Parameter)context.get(Parameter.class);
            if (parameter != null && (binding = (Binding)context.get(Binding.class)) != null) {
                Validator<?> validator;
                PhaseBinding phaseBinding = PhaseBinding.to((Submission)binding);
                Converter<?> converter = parameter.getConverter();
                if (converter != null) {
                    if (converter instanceof DeferredConverter) {
                        converter = ((DeferredConverter)converter).getDeferred();
                    }
                    phaseBinding.convertedBy(converter);
                    if (parameter instanceof ParameterConfiguration) {
                        ((ParameterConfiguration)parameter).convertedBy((Converter)new DeferredConverter(converter));
                    } else {
                        throw new RewriteException("Cannot specify @" + Deferred.class.getSimpleName() + " to [" + field + "] of class [" + field.getDeclaringClass() + "] because the parameter [" + parameter.getName() + "] is not writable.");
                    }
                }
                if ((validator = parameter.getValidator()) != null) {
                    if (validator instanceof DeferredValidator) {
                        validator = ((DeferredValidator)validator).getDeferred();
                    }
                    phaseBinding.validatedBy(validator);
                    if (parameter instanceof ParameterConfiguration) {
                        ((ParameterConfiguration)parameter).validatedBy((Validator)new DeferredValidator(validator));
                    } else {
                        throw new RewriteException("Cannot specify @" + Deferred.class.getSimpleName() + " to [" + field + "] of class [" + field.getDeclaringClass() + "] because the parameter [" + parameter.getName() + "] is not writable.");
                    }
                }
                if (annotation.before() == Phase.NONE && annotation.after() == Phase.NONE) {
                    phaseBinding.after(PhaseId.RESTORE_VIEW);
                } else if (annotation.before() != Phase.NONE && annotation.after() == Phase.NONE) {
                    phaseBinding.before(annotation.before().getPhaseId());
                } else if (annotation.before() == Phase.NONE && annotation.after() != Phase.NONE) {
                    phaseBinding.after(annotation.after().getPhaseId());
                } else {
                    throw new IllegalStateException("Error processing field " + field + ": You cannot use after() and before() at the same time.");
                }
                context.put(Binding.class, (Object)phaseBinding);
            }
        }
        if (context instanceof MethodContext) {
            Method method = ((MethodContext)context).getJavaMethod();
            Operation operation = (Operation)context.get(Operation.class);
            if (operation != null) {
                PhaseOperation<?> deferred = PhaseOperation.enqueue(operation, 10);
                if (annotation.before() == Phase.NONE && annotation.after() == Phase.NONE) {
                    deferred.after(PhaseId.RESTORE_VIEW);
                } else if (annotation.before() != Phase.NONE && annotation.after() == Phase.NONE) {
                    deferred.before(annotation.before().getPhaseId());
                } else if (annotation.before() == Phase.NONE && annotation.after() != Phase.NONE) {
                    deferred.after(annotation.after().getPhaseId());
                } else {
                    throw new IllegalStateException("Error processing field " + method + ": You cannot use after() and before() at the same time.");
                }
                context.put(Operation.class, deferred);
            }
        }
        chain.proceed();
    }
}

