/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.faces;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewDeclarationLanguage;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.common.pattern.WeightedComparator;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.common.util.Iterators;
import org.ocpsoft.rewrite.faces.RewriteNavigationHandler;
import org.ocpsoft.rewrite.faces.URLDuplicatePathCanonicalizer;
import org.ocpsoft.rewrite.faces.spi.FacesActionUrlProvider;
import org.ocpsoft.rewrite.servlet.util.URLBuilder;

public class RewriteViewHandler
extends ViewHandlerWrapper {
    protected ViewHandler parent;
    private final ThreadLocal<Boolean> bookmarkable = new ThreadLocal();
    private volatile List<FacesActionUrlProvider> providers;

    private boolean isBookmarkable() {
        Boolean result = this.bookmarkable.get();
        if (result == null) {
            result = false;
            this.bookmarkable.set(result);
        }
        return result;
    }

    public String deriveLogicalViewId(FacesContext context, String rawViewId) {
        return this.parent.deriveLogicalViewId(context, rawViewId);
    }

    private void setBookmarkable(boolean value) {
        this.bookmarkable.set(value);
    }

    public RewriteViewHandler(ViewHandler viewHandler) {
        this.parent = viewHandler;
    }

    public Locale calculateLocale(FacesContext facesContext) {
        return this.parent.calculateLocale(facesContext);
    }

    public String calculateRenderKitId(FacesContext facesContext) {
        return this.parent.calculateRenderKitId(facesContext);
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        UIViewRoot view = this.parent.createView(context, viewId);
        return view;
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        UIViewRoot view = this.parent.restoreView(context, viewId);
        return view;
    }

    public String getActionURL(FacesContext context, String viewId) {
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        String result = null;
        if (!this.isBookmarkable() && !RewriteNavigationHandler.isInNavigation(request) && viewId != null && viewId.equals(context.getViewRoot().getViewId())) {
            String parentActionURL;
            FacesActionUrlProvider provider;
            Iterator<FacesActionUrlProvider> iterator = this.getProviders().iterator();
            while (iterator.hasNext() && (result = (provider = iterator.next()).getActionURL(context, viewId)) == null) {
            }
            if (result != null && (parentActionURL = this.parent.getActionURL(context, viewId)).contains("?")) {
                URLBuilder builder = URLBuilder.createFrom((String)result);
                builder.getQueryStringBuilder().addParameters(parentActionURL);
                result = builder.toURL();
            }
        }
        if (result == null) {
            result = this.parent.getActionURL(context, viewId);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FacesActionUrlProvider> getProviders() {
        List result = this.providers;
        if (result == null) {
            RewriteViewHandler rewriteViewHandler = this;
            synchronized (rewriteViewHandler) {
                result = this.providers;
                if (result == null) {
                    result = Iterators.asList((Iterable)ServiceLoader.load(FacesActionUrlProvider.class));
                    Collections.sort(result, new WeightedComparator());
                    this.providers = result;
                }
            }
        }
        return result;
    }

    public String getBookmarkableURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        this.setBookmarkable(true);
        String result = this.parent.getBookmarkableURL(context, viewId, parameters, includeViewParams);
        this.setBookmarkable(false);
        return result;
    }

    public String getRedirectURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        return this.parent.getRedirectURL(context, viewId, parameters, includeViewParams);
    }

    public String getResourceURL(FacesContext facesContext, String path) {
        return this.parent.getResourceURL(facesContext, path);
    }

    public String getWebsocketURL(FacesContext context, String channel) {
        return this.parent.getWebsocketURL(context, channel);
    }

    public void renderView(FacesContext facesContext, UIViewRoot viewRoot) throws IOException, FacesException {
        this.parent.renderView(facesContext, viewRoot);
    }

    public void writeState(FacesContext facesContext) throws IOException {
        this.parent.writeState(facesContext);
    }

    public String deriveViewId(FacesContext context, String rawViewId) {
        String canonicalViewId = new URLDuplicatePathCanonicalizer().canonicalize(rawViewId);
        return this.parent.deriveViewId(context, canonicalViewId);
    }

    public String calculateCharacterEncoding(FacesContext context) {
        return this.parent.calculateCharacterEncoding(context);
    }

    public ViewDeclarationLanguage getViewDeclarationLanguage(FacesContext context, String viewId) {
        return this.parent.getViewDeclarationLanguage(context, viewId);
    }

    public void initView(FacesContext context) throws FacesException {
        this.parent.initView(context);
    }
}

