/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.impl;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ocpsoft.common.services.NonEnriching;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.common.util.Iterators;
import org.ocpsoft.rewrite.servlet.http.HttpRequestCycleWrapper;
import org.ocpsoft.rewrite.servlet.impl.HttpRewriteWrappedRequest;
import org.ocpsoft.rewrite.servlet.impl.HttpRewriteWrappedResponse;
import org.ocpsoft.rewrite.servlet.spi.RequestParameterProvider;

public class HttpRewriteRequestCycleWrapper
extends HttpRequestCycleWrapper
implements NonEnriching {
    private volatile List<RequestParameterProvider> providers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpRewriteRequestCycleWrapper() {
        if (this.providers == null) {
            HttpRewriteRequestCycleWrapper httpRewriteRequestCycleWrapper = this;
            synchronized (httpRewriteRequestCycleWrapper) {
                if (this.providers == null) {
                    this.providers = Iterators.asList((Iterable)ServiceLoader.load(RequestParameterProvider.class));
                }
            }
        }
    }

    public HttpServletRequest wrapRequest(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        Object result = request;
        if (HttpRewriteWrappedRequest.getCurrentInstance((ServletRequest)request) == null) {
            LinkedHashMap<String, String[]> additionalParams = new LinkedHashMap<String, String[]>();
            for (RequestParameterProvider provider : this.providers) {
                Map m = provider.getAdditionalParameters((ServletRequest)request, (ServletResponse)response);
                if (m == null) continue;
                additionalParams.putAll(m);
            }
            result = new HttpRewriteWrappedRequest(request, additionalParams);
        }
        return result;
    }

    public HttpServletResponse wrapResponse(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        Object result = response;
        if (HttpRewriteWrappedResponse.getCurrentInstance((ServletRequest)request) == null || this.getDispatcherType(request, servletContext) == DispatcherType.ERROR) {
            result = new HttpRewriteWrappedResponse(request, response, servletContext);
        }
        return result;
    }

    private DispatcherType getDispatcherType(HttpServletRequest request, ServletContext context) {
        return request.getDispatcherType();
    }

    public int priority() {
        return 0;
    }
}

