/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.ocpsoft.common.pattern.WeightedComparator;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.common.spi.ServiceEnricher;
import org.ocpsoft.common.util.Iterators;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.Version;
import org.ocpsoft.rewrite.config.ConfigurationProvider;
import org.ocpsoft.rewrite.el.spi.ExpressionLanguageProvider;
import org.ocpsoft.rewrite.event.Flow;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.servlet.ServletRewriteProvider;
import org.ocpsoft.rewrite.servlet.event.BaseRewrite;
import org.ocpsoft.rewrite.servlet.event.InboundServletRewrite;
import org.ocpsoft.rewrite.servlet.impl.HttpRewriteContextImpl;
import org.ocpsoft.rewrite.servlet.spi.ContextListener;
import org.ocpsoft.rewrite.servlet.spi.InboundRewriteProducer;
import org.ocpsoft.rewrite.servlet.spi.OutboundRewriteProducer;
import org.ocpsoft.rewrite.servlet.spi.RequestCycleWrapper;
import org.ocpsoft.rewrite.servlet.spi.RequestListener;
import org.ocpsoft.rewrite.servlet.spi.RequestParameterProvider;
import org.ocpsoft.rewrite.servlet.spi.RewriteLifecycleListener;
import org.ocpsoft.rewrite.servlet.spi.RewriteResultHandler;
import org.ocpsoft.rewrite.spi.ConfigurationCacheProvider;
import org.ocpsoft.rewrite.spi.InvocationResultHandler;
import org.ocpsoft.rewrite.spi.RewriteProvider;
import org.ocpsoft.rewrite.util.ServiceLogger;

public class RewriteFilter
implements Filter {
    Logger log = Logger.getLogger(RewriteFilter.class);
    private List<RewriteLifecycleListener<Rewrite>> listeners;
    private List<RequestCycleWrapper<ServletRequest, ServletResponse>> wrappers;
    private List<RewriteProvider<ServletContext, Rewrite>> providers;
    private List<RewriteResultHandler> resultHandlers;
    private List<InboundRewriteProducer<ServletRequest, ServletResponse>> inbound;
    private List<OutboundRewriteProducer<ServletRequest, ServletResponse, Object>> outbound;
    private ServletContext servletContext;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.log.info("RewriteFilter starting up...");
        this.servletContext = filterConfig.getServletContext();
        this.listeners = Iterators.asList((Iterable)ServiceLoader.load(RewriteLifecycleListener.class));
        this.wrappers = Iterators.asList((Iterable)ServiceLoader.load(RequestCycleWrapper.class));
        this.providers = Iterators.asList((Iterable)ServiceLoader.load(RewriteProvider.class));
        this.resultHandlers = Iterators.asList((Iterable)ServiceLoader.load(RewriteResultHandler.class));
        this.inbound = Iterators.asList((Iterable)ServiceLoader.load(InboundRewriteProducer.class));
        this.outbound = Iterators.asList((Iterable)ServiceLoader.load(OutboundRewriteProducer.class));
        Collections.sort(this.listeners, new WeightedComparator());
        Collections.sort(this.wrappers, new WeightedComparator());
        Collections.sort(this.providers, new WeightedComparator());
        Collections.sort(this.resultHandlers, new WeightedComparator());
        Collections.sort(this.inbound, new WeightedComparator());
        Collections.sort(this.outbound, new WeightedComparator());
        ServiceLogger.logLoadedServices((Logger)this.log, RewriteLifecycleListener.class, this.listeners);
        ServiceLogger.logLoadedServices((Logger)this.log, RequestCycleWrapper.class, this.wrappers);
        ServiceLogger.logLoadedServices((Logger)this.log, RewriteProvider.class, this.providers);
        ServiceLogger.logLoadedServices((Logger)this.log, RewriteResultHandler.class, this.resultHandlers);
        ServiceLogger.logLoadedServices((Logger)this.log, InboundRewriteProducer.class, this.inbound);
        ServiceLogger.logLoadedServices((Logger)this.log, OutboundRewriteProducer.class, this.outbound);
        ServiceLogger.logLoadedServices((Logger)this.log, ContextListener.class, (List)Iterators.asList((Iterable)ServiceLoader.load(ContextListener.class)));
        ServiceLogger.logLoadedServices((Logger)this.log, RequestListener.class, (List)Iterators.asList((Iterable)ServiceLoader.load(RequestListener.class)));
        ServiceLogger.logLoadedServices((Logger)this.log, RequestParameterProvider.class, (List)Iterators.asList((Iterable)ServiceLoader.load(RequestParameterProvider.class)));
        ServiceLogger.logLoadedServices((Logger)this.log, ExpressionLanguageProvider.class, (List)Iterators.asList((Iterable)ServiceLoader.load(ExpressionLanguageProvider.class)));
        ServiceLogger.logLoadedServices((Logger)this.log, InvocationResultHandler.class, (List)Iterators.asList((Iterable)ServiceLoader.load(InvocationResultHandler.class)));
        ServiceLogger.logLoadedServices((Logger)this.log, ServiceEnricher.class, (List)Iterators.asList((Iterable)ServiceLoader.load(ServiceEnricher.class)));
        ServiceLogger.logLoadedServices((Logger)this.log, ConfigurationCacheProvider.class, (List)Iterators.asList((Iterable)ServiceLoader.load(ConfigurationCacheProvider.class)));
        List configurations = Iterators.asList((Iterable)ServiceLoader.load(ConfigurationProvider.class));
        ServiceLogger.logLoadedServices((Logger)this.log, ConfigurationProvider.class, (List)configurations);
        for (RewriteProvider<ServletContext, Rewrite> provider : this.providers) {
            if (!(provider instanceof ServletRewriteProvider)) continue;
            ((ServletRewriteProvider)provider).init((Object)this.servletContext);
        }
        if (configurations == null || configurations.isEmpty()) {
            this.log.warn("No ConfigurationProviders were registered: Rewrite will not be enabled on this application. Did you forget to create a '/META-INF/services/" + ConfigurationProvider.class.getName() + " file containing the fully qualified name of your provider implementation?");
        }
        this.log.info(Version.getFullName() + " initialized.");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        InboundServletRewrite<ServletRequest, ServletResponse> event = this.createRewriteEvent(request, response);
        if (event == null) {
            this.log.warn("No Rewrite event was produced - RewriteFilter disabled on this request.");
            chain.doFilter(request, response);
        } else {
            if (request.getAttribute("_com.ocpsoft.rewrite.RequestContext") == null) {
                HttpRewriteContextImpl context = new HttpRewriteContextImpl(this.inbound, this.outbound, this.listeners, this.resultHandlers, this.wrappers, this.providers);
                request.setAttribute("_com.ocpsoft.rewrite.RequestContext", (Object)context);
            }
            for (RewriteLifecycleListener<Rewrite> rewriteLifecycleListener : this.listeners) {
                if (!rewriteLifecycleListener.handles(event)) continue;
                rewriteLifecycleListener.beforeInboundLifecycle(event);
            }
            for (RequestCycleWrapper requestCycleWrapper : this.wrappers) {
                if (!requestCycleWrapper.handles(event)) continue;
                event.setRequest(requestCycleWrapper.wrapRequest(event.getRequest(), event.getResponse(), this.servletContext));
                event.setResponse(requestCycleWrapper.wrapResponse(event.getRequest(), event.getResponse(), this.servletContext));
            }
            this.rewrite(event);
            if (!event.getFlow().is((Flow)BaseRewrite.ServletRewriteFlow.ABORT_REQUEST)) {
                this.log.debug("RewriteFilter passing control of request to underlying application.");
                if (response.isCommitted()) {
                    this.log.warn("Response has already been committed, and further write operations are not permitted. This may result in an IllegalStateException being triggered by the underlying application. To avoid this situation, consider adding a Rule `.when(Direction.isInbound().and(Response.isCommitted())).perform(Lifecycle.abort())`, or figure out where the response is being incorrectly committed and correct the bug in the offending code.");
                }
                chain.doFilter(event.getRequest(), event.getResponse());
                this.log.debug("Control of request returned to RewriteFilter.");
            }
            for (RewriteLifecycleListener<Rewrite> rewriteLifecycleListener : this.listeners) {
                if (!rewriteLifecycleListener.handles(event)) continue;
                rewriteLifecycleListener.afterInboundLifecycle(event);
            }
        }
    }

    public InboundServletRewrite<ServletRequest, ServletResponse> createRewriteEvent(ServletRequest request, ServletResponse response) {
        for (InboundRewriteProducer<ServletRequest, ServletResponse> producer : this.inbound) {
            InboundServletRewrite event = producer.createInboundRewrite(request, response, this.servletContext);
            if (event == null) continue;
            return event;
        }
        return null;
    }

    private void rewrite(InboundServletRewrite<ServletRequest, ServletResponse> event) throws ServletException, IOException {
        int i;
        int listenerCount = this.listeners.size();
        for (int i2 = 0; i2 < listenerCount; ++i2) {
            RewriteLifecycleListener<Rewrite> listener = this.listeners.get(i2);
            if (!listener.handles(event)) continue;
            listener.beforeInboundRewrite(event);
        }
        int providerCount = this.providers.size();
        for (i = 0; i < providerCount; ++i) {
            RewriteProvider<ServletContext, Rewrite> provider = this.providers.get(i);
            if (!provider.handles(event)) continue;
            provider.rewrite(event);
            if (!event.getFlow().is((Flow)BaseRewrite.ServletRewriteFlow.HANDLED)) continue;
            this.log.debug("Event flow marked as HANDLED. No further processing will occur.");
            break;
        }
        for (i = 0; i < listenerCount; ++i) {
            RewriteLifecycleListener<Rewrite> listener = this.listeners.get(i);
            if (!listener.handles(event)) continue;
            listener.afterInboundRewrite(event);
        }
        int handlerCount = this.resultHandlers.size();
        for (int i3 = 0; i3 < handlerCount; ++i3) {
            if (!this.resultHandlers.get(i3).handles(event)) continue;
            this.resultHandlers.get(i3).handleResult(event);
        }
    }

    public void destroy() {
        this.log.info("RewriteFilter shutting down...");
        for (RewriteProvider<ServletContext, Rewrite> provider : this.providers) {
            if (!(provider instanceof ServletRewriteProvider)) continue;
            ((ServletRewriteProvider)provider).shutdown((Object)this.servletContext);
        }
        this.log.info("RewriteFilter deactivated.");
    }
}

