/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.impl;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.exception.RewriteException;
import org.ocpsoft.rewrite.servlet.event.BaseRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpInboundServletRewrite;
import org.ocpsoft.rewrite.servlet.impl.BaseHttpRewrite;
import org.ocpsoft.urlbuilder.Address;

public class HttpInboundRewriteImpl
extends BaseHttpRewrite
implements HttpInboundServletRewrite {
    Logger log = Logger.getLogger(HttpInboundRewriteImpl.class);

    public HttpInboundRewriteImpl(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        super(request, response, servletContext);
    }

    public void redirectTemporary(String location) {
        this.log.debug("Temporary Redirect (302) requested: [" + location + "]");
        HttpServletResponse response = (HttpServletResponse)this.getResponse();
        if (response.isCommitted()) {
            throw new IllegalStateException("Response is already committed. Cannot issue redirect.");
        }
        this.dispatchResource = this.encodeRedirectUrl(response, location);
        this.flow = BaseRewrite.ServletRewriteFlow.REDIRECT_TEMPORARY;
    }

    public void redirectPermanent(String location) {
        this.log.debug("Permanent Redirect (301) requested: [" + location + "]");
        HttpServletResponse response = (HttpServletResponse)this.getResponse();
        if (response.isCommitted()) {
            throw new IllegalStateException("Response is already committed. Cannot issue redirect.");
        }
        this.dispatchResource = this.encodeRedirectUrl(response, location);
        this.flow = BaseRewrite.ServletRewriteFlow.REDIRECT_PERMANENT;
    }

    private String encodeRedirectUrl(HttpServletResponse response, String url) {
        return response.encodeRedirectURL(url);
    }

    public void sendStatusCode(int code) {
        HttpServletResponse response = (HttpServletResponse)this.getResponse();
        if (response.isCommitted()) {
            throw new IllegalStateException("Response is already committed. Cannot send codes.");
        }
        try {
            response.setStatus(code);
            response.flushBuffer();
            this.abort();
        }
        catch (IOException e) {
            throw new RewriteException("Could not send HTTP status code.", (Throwable)e);
        }
    }

    public void sendStatusCode(int code, String message) {
        try {
            ((HttpServletResponse)this.getResponse()).getWriter().write("<h1>" + message + "</h1>");
            this.sendStatusCode(code);
        }
        catch (IOException e) {
            throw new RewriteException("Could not send HTTP status code.", (Throwable)e);
        }
    }

    public void sendErrorCode(int code) {
        this.sendErrorCode(code, null);
    }

    public void sendErrorCode(int code, String message) {
        HttpServletResponse response = (HttpServletResponse)this.getResponse();
        if (response.isCommitted()) {
            throw new IllegalStateException("Response is already committed. Cannot send codes.");
        }
        try {
            if (message == null) {
                response.sendError(code);
            } else {
                response.sendError(code, message);
            }
            this.abort();
        }
        catch (IOException e) {
            throw new RewriteException("Could not send HTTP error code.", (Throwable)e);
        }
    }

    @Override
    public Address getAddress() {
        return this.getInboundAddress();
    }

    public String toString() {
        return "InboundRewrite [" + ((HttpServletRequest)this.getRequest()).getMethod() + " url=" + this.getAddress() + ", flow=" + this.getFlow() + ", dispatchResource=" + this.getDispatchResource() + "]";
    }
}

