/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.impl;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ocpsoft.rewrite.event.Flow;
import org.ocpsoft.rewrite.servlet.event.BaseRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.urlbuilder.Address;
import org.ocpsoft.urlbuilder.AddressBuilder;
import org.ocpsoft.urlbuilder.util.Encoder;

public abstract class BaseHttpRewrite
extends BaseRewrite<HttpServletRequest, HttpServletResponse>
implements HttpServletRewrite {
    private static final Pattern JSESSIONID_PATTERN = Pattern.compile("(?i)^(.*);jsessionid=[\\w\\.\\-\\+]+(.*)");
    private static final String JSESSIONID_REPLACEMENT = "$1$2";
    private String requestContextPath;
    private Address address;

    public BaseHttpRewrite(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        super((ServletRequest)request, (ServletResponse)response, servletContext);
    }

    public String getContextPath() {
        if (this.requestContextPath == null) {
            this.requestContextPath = ((HttpServletRequest)this.getRequest()).getContextPath();
        }
        return this.requestContextPath;
    }

    public Address getAddress() {
        return this.getInboundAddress();
    }

    public Address getInboundAddress() {
        if (this.address == null) {
            String requestURI = ((HttpServletRequest)this.getRequest()).getRequestURI();
            Matcher sessionIdMatcher = JSESSIONID_PATTERN.matcher(requestURI);
            if (sessionIdMatcher.matches()) {
                requestURI = sessionIdMatcher.replaceFirst(JSESSIONID_REPLACEMENT);
            }
            if (((HttpServletRequest)this.getRequest()).getAttribute("jakarta.servlet.forward.request_uri") != null) {
                requestURI = Encoder.path((CharSequence)requestURI);
            }
            this.address = AddressBuilder.begin().scheme((CharSequence)((HttpServletRequest)this.getRequest()).getScheme()).domain((CharSequence)((HttpServletRequest)this.getRequest()).getServerName()).port(((HttpServletRequest)this.getRequest()).getServerPort()).path((CharSequence)requestURI).queryLiteral(((HttpServletRequest)this.getRequest()).getQueryString()).buildLiteral();
        }
        return this.address;
    }

    public void setFlow(Flow flow) {
        this.flow = flow;
    }
}

