/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config.rule;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.ParameterizedPattern;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Not;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.servlet.config.DispatchType;
import org.ocpsoft.rewrite.servlet.config.Forward;
import org.ocpsoft.rewrite.servlet.config.IPath;
import org.ocpsoft.rewrite.servlet.config.Path;
import org.ocpsoft.rewrite.servlet.config.QueryString;
import org.ocpsoft.rewrite.servlet.config.Redirect;
import org.ocpsoft.rewrite.servlet.config.Substitute;
import org.ocpsoft.rewrite.servlet.config.rule.IJoin;
import org.ocpsoft.rewrite.servlet.http.event.HttpInboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.util.QueryStringBuilder;

public class Join
implements IJoin {
    private static final String CURRENT_JOIN = Join.class.getName() + "_current";
    private String id;
    private final String pattern;
    private String resource;
    private final IPath requestPath;
    private IPath resourcePath;
    private Operation operation;
    private Condition condition;
    private boolean inboundCorrection = false;

    protected Join(String pattern) {
        this.pattern = pattern;
        this.requestPath = Path.matches(pattern);
    }

    public static IJoin path(String pattern) {
        return new Join(pattern);
    }

    public static Join getCurrentJoin(HttpServletRequest request) {
        return (Join)request.getAttribute(CURRENT_JOIN);
    }

    @Override
    public IJoin to(String resource) {
        this.resource = resource;
        this.resourcePath = Path.matches(resource);
        return this;
    }

    @Override
    public IJoin withInboundCorrection() {
        this.inboundCorrection = true;
        return this;
    }

    public boolean evaluate(Rewrite event, EvaluationContext context) {
        if (event instanceof HttpInboundServletRewrite) {
            this.requestPath.withRequestBinding();
            if (Not.any((Condition)DispatchType.isForward()).and((Condition)this.requestPath).evaluate(event, context) && (this.condition == null || this.condition.evaluate(event, context))) {
                if (this.operation != null) {
                    context.addPreOperation(this.operation);
                }
                return true;
            }
            if (this.inboundCorrection && this.resourcePath.andNot((Condition)DispatchType.isForward()).evaluate(event, context) && (this.condition == null || this.condition.evaluate(event, context))) {
                List names = this.requestPath.getPathExpression().getParameterNames();
                for (String name : names) {
                    if (QueryString.parameterExists(name).evaluate(event, context)) continue;
                    return false;
                }
                context.addPreOperation((Operation)Redirect.permanent(((HttpInboundServletRewrite)event).getContextPath() + this.pattern));
                return true;
            }
        } else if (event instanceof HttpOutboundServletRewrite) {
            List<String> parameters = this.getPathRequestParameters();
            IPath outbound = this.resourcePath;
            for (String name : parameters) {
                outbound = outbound.and((Condition)QueryString.parameterExists(name));
            }
            if (outbound.evaluate(event, context) && (this.condition == null || this.condition.evaluate(event, context))) {
                if (this.operation != null) {
                    context.addPreOperation(this.operation);
                }
                return true;
            }
        }
        return false;
    }

    private List<String> getPathRequestParameters() {
        List nonQueryParameters = this.resourcePath.getPathExpression().getParameterNames();
        List queryParameters = this.requestPath.getPathExpression().getParameterNames();
        queryParameters.removeAll(nonQueryParameters);
        return queryParameters;
    }

    public void perform(Rewrite event, EvaluationContext context) {
        if (event instanceof HttpInboundServletRewrite) {
            this.saveCurrentJoin((HttpServletRequest)((HttpInboundServletRewrite)event).getRequest());
            Forward.to(this.resource).perform(event, context);
        } else if (event instanceof HttpOutboundServletRewrite) {
            List<String> parameters = this.getPathRequestParameters();
            String outboundURL = ((HttpOutboundServletRewrite)event).getOutboundURL();
            QueryStringBuilder query = QueryStringBuilder.createNew();
            if (outboundURL.contains("?")) {
                query.addParameters(outboundURL);
                for (String string : parameters) {
                    List<String> values = query.removeParameter(string);
                    if (values.size() <= 1) continue;
                    query.addParameter(string, values.subList(1, values.size()).toArray(new String[0]));
                }
            }
            Substitute.with(this.pattern + query.toQueryString()).perform(event, context);
        }
    }

    private void saveCurrentJoin(HttpServletRequest request) {
        request.setAttribute(CURRENT_JOIN, (Object)this);
    }

    public IJoin.JoinParameter where(String parameter) {
        return new IJoin.JoinParameter(this, this.requestPath.getPathExpression().getParameter(parameter) != null ? (IPath.PathParameter)this.requestPath.where(parameter) : null, this.resourcePath.getPathExpression().getParameter(parameter) != null ? (IPath.PathParameter)this.resourcePath.where(parameter) : null);
    }

    public IJoin.JoinParameter where(String param, Binding binding) {
        return (IJoin.JoinParameter)this.where(param).bindsTo(binding);
    }

    public String getId() {
        return this.id;
    }

    @Override
    public IJoin when(Condition condition) {
        this.condition = condition;
        return this;
    }

    @Override
    public IJoin perform(Operation operation) {
        this.operation = operation;
        return this;
    }

    @Override
    public IJoin withId(String id) {
        this.id = id;
        return this;
    }

    public String toString() {
        return "Join [url=" + this.pattern + ", to=" + this.resource + ", id=" + this.id + ", inboundCorrection=" + this.inboundCorrection + "]";
    }

    @Override
    public IJoin withRequestBinding() {
        this.requestPath.withRequestBinding();
        return this;
    }

    @Override
    public ParameterizedPattern getPathExpression() {
        return this.requestPath.getPathExpression();
    }

    @Override
    public ParameterizedPattern getResourcexpression() {
        return this.resourcePath.getPathExpression();
    }
}

