/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.net.MalformedURLException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.bind.Bindable;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.bind.ParameterizedPattern;
import org.ocpsoft.rewrite.bind.RegexCapture;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.config.IResource;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.util.ParameterStore;

public class Resource
extends HttpCondition
implements IResource {
    private static final Logger log = Logger.getLogger(Resource.class);
    private final ParameterizedPattern resource;
    private final ParameterStore<IResource.ResourceParameter> parameters = new ParameterStore();

    private Resource(String resource) {
        this.resource = new ParameterizedPattern(resource);
        for (RegexCapture parameter : this.resource.getParameters().values()) {
            this.where(parameter.getName()).bindsTo((Binding)Evaluation.property((CharSequence)parameter.getName()));
        }
    }

    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        if (this.resource != null) {
            String file = this.resource.build((Rewrite)event, context, this.parameters.getParameters());
            try {
                if (((HttpServletRequest)event.getRequest()).getServletContext().getResource(file) != null) {
                    Map parameters = this.resource.parse((Rewrite)event, context, file);
                    for (RegexCapture capture : parameters.keySet()) {
                        if (Bindings.enqueueSubmission((Rewrite)event, (EvaluationContext)context, (Bindable)this.where(capture.getName()), parameters.get(capture))) continue;
                        return false;
                    }
                    return true;
                }
            }
            catch (MalformedURLException e) {
                log.debug("Invalid file format [{}]", (Object)file);
            }
        }
        return false;
    }

    public static Resource exists(String resource) {
        return new Resource(resource);
    }

    public IResource.ResourceParameter where(String param) {
        return this.parameters.where(param, new IResource.ResourceParameter(this, this.resource.getParameter(param)));
    }

    public IResource.ResourceParameter where(String param, Binding binding) {
        return (IResource.ResourceParameter)this.where(param).bindsTo(binding);
    }

    @Override
    public ParameterizedPattern getResourceExpression() {
        return this.resource;
    }
}

