/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.ocpsoft.common.pattern.WeightedComparator;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.common.spi.ServiceEnricher;
import org.ocpsoft.common.util.Iterators;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.config.ConfigurationCacheProvider;
import org.ocpsoft.rewrite.config.ConfigurationProvider;
import org.ocpsoft.rewrite.el.spi.ExpressionLanguageProvider;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.servlet.ServletRewriteProvider;
import org.ocpsoft.rewrite.servlet.event.BaseRewrite;
import org.ocpsoft.rewrite.servlet.event.InboundServletRewrite;
import org.ocpsoft.rewrite.servlet.impl.HttpRewriteContextImpl;
import org.ocpsoft.rewrite.servlet.spi.ContextListener;
import org.ocpsoft.rewrite.servlet.spi.InboundRewriteProducer;
import org.ocpsoft.rewrite.servlet.spi.OutboundRewriteProducer;
import org.ocpsoft.rewrite.servlet.spi.RequestCycleWrapper;
import org.ocpsoft.rewrite.servlet.spi.RequestListener;
import org.ocpsoft.rewrite.servlet.spi.RequestParameterProvider;
import org.ocpsoft.rewrite.servlet.spi.RewriteLifecycleListener;
import org.ocpsoft.rewrite.spi.InvocationResultHandler;
import org.ocpsoft.rewrite.spi.RewriteProvider;
import org.ocpsoft.rewrite.util.ServiceLogger;

public class RewriteFilter
implements Filter {
    Logger log = Logger.getLogger(RewriteFilter.class);
    private List<RewriteLifecycleListener<Rewrite>> listeners;
    private List<RequestCycleWrapper<ServletRequest, ServletResponse>> wrappers;
    private List<RewriteProvider<ServletContext, Rewrite>> providers;
    private List<InboundRewriteProducer<ServletRequest, ServletResponse>> inbound;
    private List<OutboundRewriteProducer<ServletRequest, ServletResponse, Object>> outbound;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.log.info("RewriteFilter starting up...");
        this.listeners = Iterators.asList((Iterable)ServiceLoader.load(RewriteLifecycleListener.class));
        this.wrappers = Iterators.asList((Iterable)ServiceLoader.load(RequestCycleWrapper.class));
        this.providers = Iterators.asList((Iterable)ServiceLoader.load(RewriteProvider.class));
        this.inbound = Iterators.asList((Iterable)ServiceLoader.load(InboundRewriteProducer.class));
        this.outbound = Iterators.asList((Iterable)ServiceLoader.load(OutboundRewriteProducer.class));
        Collections.sort(this.listeners, new WeightedComparator());
        Collections.sort(this.wrappers, new WeightedComparator());
        Collections.sort(this.providers, new WeightedComparator());
        Collections.sort(this.inbound, new WeightedComparator());
        Collections.sort(this.outbound, new WeightedComparator());
        ServiceLogger.logLoadedServices((Logger)this.log, RewriteLifecycleListener.class, this.listeners);
        ServiceLogger.logLoadedServices((Logger)this.log, RequestCycleWrapper.class, this.wrappers);
        ServiceLogger.logLoadedServices((Logger)this.log, RewriteProvider.class, this.providers);
        ServiceLogger.logLoadedServices((Logger)this.log, InboundRewriteProducer.class, this.inbound);
        ServiceLogger.logLoadedServices((Logger)this.log, OutboundRewriteProducer.class, this.outbound);
        ServiceLogger.logLoadedServices((Logger)this.log, ContextListener.class, (List)Iterators.asList((Iterable)ServiceLoader.load(ContextListener.class)));
        ServiceLogger.logLoadedServices((Logger)this.log, RequestListener.class, (List)Iterators.asList((Iterable)ServiceLoader.load(RequestListener.class)));
        ServiceLogger.logLoadedServices((Logger)this.log, RequestParameterProvider.class, (List)Iterators.asList((Iterable)ServiceLoader.load(RequestParameterProvider.class)));
        ServiceLogger.logLoadedServices((Logger)this.log, ExpressionLanguageProvider.class, (List)Iterators.asList((Iterable)ServiceLoader.load(ExpressionLanguageProvider.class)));
        ServiceLogger.logLoadedServices((Logger)this.log, InvocationResultHandler.class, (List)Iterators.asList((Iterable)ServiceLoader.load(InvocationResultHandler.class)));
        ServiceLogger.logLoadedServices((Logger)this.log, ServiceEnricher.class, (List)Iterators.asList((Iterable)ServiceLoader.load(ServiceEnricher.class)));
        ServiceLogger.logLoadedServices((Logger)this.log, ConfigurationCacheProvider.class, (List)Iterators.asList((Iterable)ServiceLoader.load(ConfigurationCacheProvider.class)));
        List configurations = Iterators.asList((Iterable)ServiceLoader.load(ConfigurationProvider.class));
        ServiceLogger.logLoadedServices((Logger)this.log, ConfigurationProvider.class, (List)configurations);
        for (RewriteProvider<ServletContext, Rewrite> provider : this.providers) {
            if (!(provider instanceof ServletRewriteProvider)) continue;
            ((ServletRewriteProvider)provider).init((Object)filterConfig.getServletContext());
        }
        if (configurations == null || configurations.isEmpty()) {
            this.log.warn("No ConfigurationProviders were registered: Rewrite will not be enabled on this application. Did you forget to create a '/META-INF/services/" + ConfigurationProvider.class.getName() + " file containing the fully qualified name of your provider implementation?");
        }
        this.log.info("RewriteFilter initialized.");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        InboundServletRewrite<ServletRequest, ServletResponse> event = this.createRewriteEvent(request, response);
        if (event == null) {
            this.log.warn("No Rewrite event was produced - RewriteFilter disabled on this request.");
            chain.doFilter(request, response);
        } else {
            if (request.getAttribute("_com.ocpsoft.rewrite.RequestContext") == null) {
                HttpRewriteContextImpl context = new HttpRewriteContextImpl(this.inbound, this.outbound, this.listeners, this.wrappers, this.providers);
                request.setAttribute("_com.ocpsoft.rewrite.RequestContext", (Object)context);
            }
            for (RewriteLifecycleListener<Rewrite> rewriteLifecycleListener : this.listeners) {
                if (!rewriteLifecycleListener.handles(event)) continue;
                rewriteLifecycleListener.beforeInboundLifecycle(event);
            }
            for (RequestCycleWrapper requestCycleWrapper : this.wrappers) {
                if (!requestCycleWrapper.handles(event)) continue;
                event.setRequest(requestCycleWrapper.wrapRequest(event.getRequest(), event.getResponse()));
                event.setResponse(requestCycleWrapper.wrapResponse(event.getRequest(), event.getResponse()));
            }
            this.rewrite(event);
            if (!event.getFlow().is(BaseRewrite.Flow.ABORT_REQUEST)) {
                this.log.debug("RewriteFilter passing control of request to underlying application.");
                chain.doFilter(event.getRequest(), event.getResponse());
                this.log.debug("Control of request returned to RewriteFilter.");
            }
            for (RewriteLifecycleListener<Rewrite> rewriteLifecycleListener : this.listeners) {
                if (!rewriteLifecycleListener.handles(event)) continue;
                rewriteLifecycleListener.afterInboundLifecycle(event);
            }
        }
    }

    public InboundServletRewrite<ServletRequest, ServletResponse> createRewriteEvent(ServletRequest request, ServletResponse response) {
        for (InboundRewriteProducer<ServletRequest, ServletResponse> producer : this.inbound) {
            InboundServletRewrite event = producer.createInboundRewrite(request, response);
            if (event == null) continue;
            return event;
        }
        return null;
    }

    private void rewrite(InboundServletRewrite<ServletRequest, ServletResponse> event) throws ServletException, IOException {
        for (RewriteLifecycleListener<Rewrite> rewriteLifecycleListener : this.listeners) {
            if (!rewriteLifecycleListener.handles(event)) continue;
            rewriteLifecycleListener.beforeInboundRewrite(event);
        }
        for (RewriteProvider rewriteProvider : this.providers) {
            if (!rewriteProvider.handles(event)) continue;
            rewriteProvider.rewrite(event);
            if (!event.getFlow().is(BaseRewrite.Flow.HANDLED)) continue;
            this.log.debug("Event flow marked as HANDLED. No further processing will occur.");
            break;
        }
        for (RewriteLifecycleListener<Rewrite> rewriteLifecycleListener : this.listeners) {
            if (!rewriteLifecycleListener.handles(event)) continue;
            rewriteLifecycleListener.afterInboundRewrite(event);
        }
        if (event.getFlow().is(BaseRewrite.Flow.ABORT_REQUEST)) {
            HttpServletResponse response;
            if (event.getFlow().is(BaseRewrite.Flow.FORWARD)) {
                this.log.debug("Issuing internal FORWARD to [{}].", (Object)event.getDispatchResource());
                event.getRequest().getRequestDispatcher(event.getDispatchResource()).forward(event.getRequest(), event.getResponse());
            } else if (event.getFlow().is(BaseRewrite.Flow.REDIRECT_PERMANENT)) {
                this.log.debug("Issuing 301 permanent REDIRECT to [{}].", (Object)event.getDispatchResource());
                response = (HttpServletResponse)event.getResponse();
                response.setStatus(301);
                response.setHeader("Location", event.getDispatchResource());
                response.flushBuffer();
            } else if (event.getFlow().is(BaseRewrite.Flow.REDIRECT_TEMPORARY)) {
                this.log.debug("Issuing 302 temporary REDIRECT to [{}].", (Object)event.getDispatchResource());
                response = (HttpServletResponse)event.getResponse();
                response.setStatus(302);
                response.setHeader("Location", event.getDispatchResource());
                response.flushBuffer();
            } else {
                this.log.debug("ABORT requested. Terminating request NOW.");
            }
        } else if (event.getFlow().is(BaseRewrite.Flow.INCLUDE)) {
            this.log.debug("Issuing internal INCLUDE to [{}].", (Object)event.getDispatchResource());
            event.getRequest().getRequestDispatcher(event.getDispatchResource()).include(event.getRequest(), event.getResponse());
        }
    }

    public void destroy() {
        this.log.info("RewriteFilter shutting down...");
        this.log.info("RewriteFilter deactivated.");
    }
}

