/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Arrays;
import java.util.List;
import org.ocpsoft.rewrite.bind.Bindable;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.RegexCapture;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.Constraint;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterBuilder;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.Transform;

public interface IRequestParameter
extends Parameterized<IRequestParameter, RequestParameterParameter, String>,
ConditionBuilder {

    public static class RequestParameterParameter
    extends ParameterBuilder<RequestParameterParameter, String>
    implements IRequestParameterParameter {
        private final IRequestParameter parent;
        private final List<RegexCapture> parameters;

        public RequestParameterParameter(IRequestParameter path, RegexCapture ... captures) {
            super((Object[])captures);
            this.parent = path;
            this.parameters = Arrays.asList(captures);
        }

        public RequestParameterParameter constrainedBy(Constraint<String> constraint) {
            for (RegexCapture parameter : this.parameters) {
                if (parameter == null) continue;
                parameter.constrainedBy(constraint);
            }
            return this;
        }

        public RequestParameterParameter transformedBy(Transform<String> transform) {
            for (RegexCapture parameter : this.parameters) {
                if (parameter == null) continue;
                parameter.transformedBy(transform);
            }
            return this;
        }

        public RequestParameterParameter where(String param) {
            return (RequestParameterParameter)this.parent.where(param);
        }

        public RequestParameterParameter where(String param, Binding binding) {
            return (RequestParameterParameter)this.parent.where(param, binding);
        }

        @Override
        public IRequestParameterParameter matches(String string) {
            for (RegexCapture parameter : this.parameters) {
                if (parameter == null) continue;
                parameter.matches(string);
            }
            return this;
        }

        public String getName() {
            for (RegexCapture parameter : this.parameters) {
                if (parameter == null) continue;
                return parameter.getName();
            }
            return null;
        }

        public boolean evaluate(Rewrite event, EvaluationContext context) {
            return this.parent.evaluate(event, context);
        }

        public ConditionBuilder and(Condition condition) {
            return this.parent.and(condition);
        }

        public ConditionBuilder andNot(Condition condition) {
            return this.parent.andNot(condition);
        }

        public ConditionBuilder or(Condition condition) {
            return this.parent.or(condition);
        }

        public ConditionBuilder orNot(Condition condition) {
            return this.parent.orNot(condition);
        }
    }

    public static interface IRequestParameterParameter
    extends IRequestParameter,
    Bindable<RequestParameterParameter>,
    Parameter<RequestParameterParameter, String> {
        public IRequestParameterParameter matches(String var1);
    }
}

