/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Bindings;
import org.ocpsoft.rewrite.bind.ParameterizedPattern;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public class Header
extends HttpCondition {
    private final ParameterizedPattern name;
    private final ParameterizedPattern value;

    private Header(String name, String value) {
        Assert.notNull((Object)name, (String)"Header name pattern cannot be null.");
        Assert.notNull((Object)value, (String)"Header value pattern cannot be null.");
        this.name = new ParameterizedPattern(name);
        this.value = new ParameterizedPattern(value);
    }

    public static Header matches(String name, String value) {
        return new Header(name, value);
    }

    public static Header exists(String name) {
        return new Header(name, ".*");
    }

    public static Header valueExists(String value) {
        return new Header(".*", value);
    }

    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        HttpServletRequest request = (HttpServletRequest)event.getRequest();
        for (String header : Collections.list(request.getHeaderNames())) {
            if (!this.name.matches((Rewrite)event, context, header) || !this.matchesValue((Rewrite)event, context, request, header)) continue;
            Map parameters = this.name.parse((Rewrite)event, context, header);
            parameters = this.value.parse((Rewrite)event, context, header);
            if (!Bindings.enqueuePreOperationSubmissions((Rewrite)event, (EvaluationContext)context, (Map)parameters) || !Bindings.enqueuePreOperationSubmissions((Rewrite)event, (EvaluationContext)context, (Map)parameters)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesValue(Rewrite event, EvaluationContext context, HttpServletRequest request, String header) {
        for (String contents : Collections.list(request.getHeaders(header))) {
            if (!this.value.matches(event, context, contents)) continue;
            return true;
        }
        return false;
    }
}

